/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import com.rapidminer.gui.tools.FilterListener;
import com.rapidminer.gui.tools.SelectionNavigationListener;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.JTextField;
import javax.swing.text.Document;

public class FilterTextField
extends JTextField {
    private static final long serialVersionUID = -7613936832117084427L;
    private static final String DEFAULT_FILTER_TEXT = "[Filter]";
    private final Collection<FilterListener> filterListeners = new LinkedList<FilterListener>();
    private final Collection<SelectionNavigationListener> selectionNavigationListeners = new LinkedList<SelectionNavigationListener>();

    public FilterTextField() {
        this(null, null, 0);
    }

    public FilterTextField(int columns) {
        this(null, null, columns);
    }

    public FilterTextField(String text) {
        this(null, text, 0);
    }

    public FilterTextField(String text, int columns) {
        this(null, text, columns);
    }

    public FilterTextField(Document doc, String text, int columns) {
        super(doc, text, columns);
        this.setForeground(Color.LIGHT_GRAY);
        this.setText(DEFAULT_FILTER_TEXT);
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e == null || e.getKeyCode() != 8 && e.getKeyCode() != 27 && e.getKeyCode() != 127 && e.getKeyCode() != 16 && e.getKeyCode() != 18 && e.getKeyCode() != 65406 && e.getKeyCode() != 17 && e.getKeyCode() != 157 && !e.isActionKey()) {
                    FilterTextField.this.setForeground(Color.BLACK);
                }
                switch (e.getKeyCode()) {
                    case 38: {
                        for (SelectionNavigationListener l : FilterTextField.this.selectionNavigationListeners) {
                            l.up();
                        }
                        e.consume();
                        return;
                    }
                    case 40: {
                        for (SelectionNavigationListener l : FilterTextField.this.selectionNavigationListeners) {
                            l.down();
                        }
                        e.consume();
                        return;
                    }
                    case 10: {
                        for (SelectionNavigationListener l : FilterTextField.this.selectionNavigationListeners) {
                            l.selected();
                        }
                        e.consume();
                        return;
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                FilterTextField.this.updateFilter(e);
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                super.mouseReleased(e);
                FilterTextField.this.selectAll();
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                FilterTextField.this.updateFilter(null);
            }
        });
    }

    public void addFilterListener(FilterListener l) {
        this.filterListeners.add(l);
    }

    public void removeFilterListener(FilterListener l) {
        this.filterListeners.remove(l);
    }

    public void addSelectionNavigationListener(SelectionNavigationListener l) {
        this.selectionNavigationListeners.add(l);
    }

    public void removeSelectionNavigationListener(SelectionNavigationListener l) {
        this.selectionNavigationListeners.remove(l);
    }

    public void clearFilter() {
        this.setForeground(Color.LIGHT_GRAY);
        this.setText(DEFAULT_FILTER_TEXT);
        this.updateFilter(null);
    }

    private void updateFilter(KeyEvent e) {
        String filterText = this.getText();
        if (!(filterText != null && filterText.length() != 0 || e != null && (e.getKeyCode() == 8 || e.getKeyCode() == 127 || e.getKeyCode() == 16 || e.getKeyCode() == 18 || e.getKeyCode() == 65406 || e.getKeyCode() == 17 || e.getKeyCode() == 157 || e.isActionKey()))) {
            this.setForeground(Color.LIGHT_GRAY);
            this.setText(DEFAULT_FILTER_TEXT);
        }
        if (DEFAULT_FILTER_TEXT.equals(filterText)) {
            filterText = null;
        }
        for (FilterListener l : this.filterListeners) {
            l.valueChanged(filterText);
        }
    }
}

