/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import com.rapidminer.gui.actions.MoveColumnAction;
import com.rapidminer.gui.tools.CellColorProvider;
import com.rapidminer.gui.tools.CellColorProviderAlternating;
import com.rapidminer.gui.tools.ColoredTableCellRenderer;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ExtendedJTableColumnFitMouseListener;
import com.rapidminer.gui.tools.ExtendedJTablePacker;
import com.rapidminer.gui.tools.ExtendedJTableSorterModel;
import com.rapidminer.gui.tools.IconSize;
import com.rapidminer.gui.tools.ResourceMenu;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.actions.AddToSortingColumnsAction;
import com.rapidminer.gui.tools.actions.EqualColumnWidthsAction;
import com.rapidminer.gui.tools.actions.FitAllColumnWidthsAction;
import com.rapidminer.gui.tools.actions.FitColumnWidthAction;
import com.rapidminer.gui.tools.actions.RestoreOriginalColumnOrderAction;
import com.rapidminer.gui.tools.actions.SelectColumnAction;
import com.rapidminer.gui.tools.actions.SelectRowAction;
import com.rapidminer.gui.tools.actions.SortByColumnAction;
import com.rapidminer.gui.tools.actions.SortColumnsAccordingToNameAction;
import com.rapidminer.gui.tools.components.ToolTipWindow;
import com.rapidminer.report.Tableable;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.container.Pair;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.Date;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class ExtendedJTable
extends JTable
implements Tableable,
MouseListener {
    private static final long serialVersionUID = 4840252601155251257L;
    private static final int DEFAULT_MAX_ROWS_FOR_SORTING = 100000;
    private static final int DEFAULT_COLUMN_WIDTH = 100;
    public static final int NO_DATE_FORMAT = -1;
    public static final int DATE_FORMAT = 0;
    public static final int TIME_FORMAT = 1;
    public static final int DATE_TIME_FORMAT = 2;
    private Action ROW_ACTION = new SelectRowAction(this, IconSize.SMALL);
    private Action COLUMN_ACTION = new SelectColumnAction(this, IconSize.SMALL);
    private Action FIT_COLUMN_ACTION = new FitColumnWidthAction(this, IconSize.SMALL);
    private Action FIT_ALL_COLUMNS_ACTION = new FitAllColumnWidthsAction(this, IconSize.SMALL);
    private Action EQUAL_WIDTHS_ACTION = new EqualColumnWidthsAction(this, IconSize.SMALL);
    private Action SORTING_DESCENDING_ACTION = new SortByColumnAction(this, -1, IconSize.SMALL);
    private Action SORTING_ASCENDING_ACTION = new SortByColumnAction(this, 1, IconSize.SMALL);
    private Action ADD_TO_SORTING_DESCENDING_ACTION = new AddToSortingColumnsAction(this, -1, IconSize.SMALL);
    private Action ADD_TO_SORTING_ASCENDING_ACTION = new AddToSortingColumnsAction(this, 1, IconSize.SMALL);
    private Action SORT_COLUMNS_BY_NAME_ACTION = new SortColumnsAccordingToNameAction(this, IconSize.SMALL);
    private Action RESTORE_COLUMN_ORDER_ACTION = new RestoreOriginalColumnOrderAction(this, IconSize.SMALL);
    private boolean sortable = true;
    private CellColorProvider cellColorProvider = new CellColorProviderAlternating();
    private boolean useColoredCellRenderer = true;
    private transient ColoredTableCellRenderer renderer = new ColoredTableCellRenderer();
    private ExtendedJTableSorterModel tableSorter = null;
    private ExtendedJScrollPane scrollPaneParent = null;
    private ExtendedJTablePacker packer = null;
    private boolean fixFirstColumn = false;
    private String[] originalOrder = null;
    private boolean showPopopUpMenu = true;
    private boolean[] cutOnLineBreaks;
    private int[] maximalTextLengths;

    public ExtendedJTable() {
        this(null, true);
    }

    public ExtendedJTable(boolean sortable) {
        this(null, sortable);
    }

    public ExtendedJTable(TableModel model, boolean sortable) {
        this(model, sortable, true);
    }

    public ExtendedJTable(TableModel model, boolean sortable, boolean columnMovable) {
        this(model, sortable, columnMovable, true);
    }

    public ExtendedJTable(boolean sortable, boolean columnMovable, boolean autoResize) {
        this(null, sortable, columnMovable, autoResize);
    }

    public ExtendedJTable(TableModel model, boolean sortable, boolean columnMovable, boolean autoResize) {
        this(model, sortable, columnMovable, autoResize, true, false);
    }

    public ExtendedJTable(TableModel model, boolean sortable, boolean columnMovable, boolean autoResize, boolean useColoredCellRenderer, boolean fixFirstColumn) {
        this.sortable = sortable;
        this.useColoredCellRenderer = useColoredCellRenderer;
        this.fixFirstColumn = fixFirstColumn;
        this.setSelectionMode(2);
        this.setColumnSelectionAllowed(true);
        this.setRowSelectionAllowed(true);
        this.setRowHeight(this.getRowHeight() + 4);
        this.getTableHeader().setReorderingAllowed(columnMovable);
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        if (!autoResize) {
            this.setAutoResizeMode(0);
        }
        if (model != null) {
            this.setModel(model);
        }
        this.getTableHeader().addMouseListener(new ExtendedJTableColumnFitMouseListener());
        this.addMouseListener(this);
    }

    public void installToolTip() {
        new ToolTipWindow(new TableToolTipProvider(), this);
        this.setToolTipText(null);
    }

    protected Object readResolve() {
        this.renderer = new ColoredTableCellRenderer();
        return this;
    }

    protected ExtendedJTableSorterModel getTableSorter() {
        return this.tableSorter;
    }

    public int getDateFormat(int row, int column) {
        return -1;
    }

    public void setCellColorProvider(CellColorProvider cellColorProvider) {
        this.cellColorProvider = cellColorProvider;
    }

    public CellColorProvider getCellColorProvider() {
        return this.cellColorProvider;
    }

    public void setSortable(boolean sortable) {
        this.sortable = sortable;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public void setShowPopupMenu(boolean showPopupMenu) {
        this.showPopopUpMenu = showPopupMenu;
    }

    public void setFixFirstColumnForRearranging(boolean fixFirstColumn) {
        this.fixFirstColumn = fixFirstColumn;
    }

    public void setMaximalTextLength(int maximalTextLength) {
        Arrays.fill(this.maximalTextLengths, maximalTextLength);
    }

    public void setMaximalTextLength(int maximalTextLength, int column) {
        this.maximalTextLengths[column] = maximalTextLength;
    }

    public void setCutOnLineBreak(boolean enable) {
        Arrays.fill(this.cutOnLineBreaks, enable);
    }

    public void setCutOnLineBreak(boolean enable, int column) {
        this.cutOnLineBreaks[column] = enable;
    }

    @Override
    public void setModel(final TableModel model) {
        boolean shouldSort;
        boolean bl = shouldSort = this.sortable && this.checkIfSortable(model);
        if (shouldSort) {
            this.tableSorter = new ExtendedJTableSorterModel(model);
            this.tableSorter.setTableHeader(this.getTableHeader());
            super.setModel(this.tableSorter);
        } else {
            super.setModel(model);
            this.tableSorter = null;
        }
        this.originalOrder = new String[model.getColumnCount()];
        for (int c = 0; c < model.getColumnCount(); ++c) {
            this.originalOrder[c] = model.getColumnName(c);
        }
        this.cutOnLineBreaks = new boolean[model.getColumnCount()];
        this.maximalTextLengths = new int[model.getColumnCount()];
        Arrays.fill(this.maximalTextLengths, Integer.MAX_VALUE);
        model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                int oldLength = ExtendedJTable.this.cutOnLineBreaks.length;
                if (oldLength != model.getColumnCount()) {
                    ExtendedJTable.access$102(ExtendedJTable.this, Arrays.copyOf(ExtendedJTable.this.cutOnLineBreaks, model.getColumnCount()));
                    ExtendedJTable.access$202(ExtendedJTable.this, Arrays.copyOf(ExtendedJTable.this.maximalTextLengths, model.getColumnCount()));
                    if (oldLength < ExtendedJTable.this.cutOnLineBreaks.length) {
                        Arrays.fill(ExtendedJTable.this.cutOnLineBreaks, oldLength, ExtendedJTable.this.cutOnLineBreaks.length, false);
                        Arrays.fill(ExtendedJTable.this.maximalTextLengths, oldLength, ExtendedJTable.this.cutOnLineBreaks.length, Integer.MAX_VALUE);
                    }
                }
            }
        });
    }

    public void setSortingStatus(int status, boolean cancelSorting) {
        if (this.getModel() instanceof ExtendedJTableSorterModel) {
            int column;
            ExtendedJTableSorterModel sorterModel = (ExtendedJTableSorterModel)this.getModel();
            JTableHeader h = this.getTableHeader();
            TableColumnModel columnModel = h.getColumnModel();
            int viewColumn = this.getSelectedColumn();
            if (viewColumn != -1 && (column = columnModel.getColumn(viewColumn).getModelIndex()) != -1) {
                if (sorterModel.isSorting() && cancelSorting) {
                    sorterModel.cancelSorting();
                }
                sorterModel.setSortingStatus(column, status);
            }
        }
    }

    public void pack() {
        this.packer = new ExtendedJTablePacker(true);
        if (this.isShowing()) {
            this.packer.pack(this);
            this.packer = null;
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.packer != null) {
            this.packer.pack(this);
            this.packer = null;
        }
    }

    public void unpack() {
        JTableHeader header = this.getTableHeader();
        if (header != null) {
            for (int c = 0; c < this.getColumnCount(); ++c) {
                TableColumn tableColumn = header.getColumnModel().getColumn(c);
                header.setResizingColumn(tableColumn);
                int width = 100;
                if (this.getWidth() / width > this.getColumnCount()) {
                    width = this.getWidth() / this.getColumnCount();
                }
                tableColumn.setWidth(width);
            }
        }
    }

    public void packColumn() {
        TableColumn tableColumn;
        int col;
        JTableHeader header = this.getTableHeader();
        if (header != null && (col = this.getSelectedColumn()) >= 0 && (tableColumn = header.getColumnModel().getColumn(col)) != null) {
            int width = (int)header.getDefaultRenderer().getTableCellRendererComponent(this, tableColumn.getIdentifier(), false, false, -1, col).getPreferredSize().getWidth();
            int firstRow = 0;
            int lastRow = this.getRowCount();
            ExtendedJScrollPane scrollPane = this.getExtendedScrollPane();
            if (scrollPane != null) {
                JViewport viewport = scrollPane.getViewport();
                Rectangle viewRect = viewport.getViewRect();
                if (viewport.getHeight() < this.getHeight()) {
                    firstRow = this.rowAtPoint(new Point(0, viewRect.y));
                    firstRow = Math.max(0, firstRow);
                    lastRow = this.rowAtPoint(new Point(0, viewRect.y + viewRect.height - 1));
                    lastRow = Math.min(lastRow, this.getRowCount());
                }
            }
            for (int row = firstRow; row < lastRow; ++row) {
                int preferedWidth = (int)this.getCellRenderer(row, col).getTableCellRendererComponent(this, this.getValueAt(row, col), false, false, row, col).getPreferredSize().getWidth();
                width = Math.max(width, preferedWidth);
            }
            header.setResizingColumn(tableColumn);
            tableColumn.setWidth(width + this.getIntercellSpacing().width);
        }
    }

    public void sortColumnsAccordingToNames() {
        int offset = 0;
        if (this.fixFirstColumn) {
            offset = 1;
        }
        for (int i = offset; i < this.getColumnCount(); ++i) {
            int minIndex = -1;
            String minName = null;
            for (int j = i; j < this.getColumnCount(); ++j) {
                String currentName = this.getColumnName(j);
                if (minName != null && currentName.compareTo(minName) >= 0) continue;
                minName = currentName;
                minIndex = j;
            }
            this.moveColumn(minIndex, i);
        }
    }

    public void restoreOriginalColumnOrder() {
        block0: for (int i = 0; i < this.originalOrder.length; ++i) {
            String nextColumn = this.originalOrder[i];
            for (int j = i; j < this.getColumnCount(); ++j) {
                String candidateName = this.getColumnName(j);
                if (!nextColumn.equals(candidateName)) continue;
                this.moveColumn(j, i);
                continue block0;
            }
        }
    }

    @Override
    public Dimension getIntercellSpacing() {
        Dimension dimension = super.getIntercellSpacing();
        dimension.width += 6;
        return dimension;
    }

    private boolean checkIfSortable(TableModel model) {
        int maxSortableRows = 100000;
        String maxString = System.getProperty("rapidminer.gui.max_sortable_rows");
        if (maxString != null) {
            try {
                maxSortableRows = Integer.parseInt(maxString);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return model.getRowCount() <= maxSortableRows;
    }

    @Override
    public void columnMoved(TableColumnModelEvent e) {
        if (this.isEditing()) {
            this.cellEditor.stopCellEditing();
        }
        super.columnMoved(e);
    }

    @Override
    public void columnMarginChanged(ChangeEvent e) {
        if (this.isEditing()) {
            this.cellEditor.stopCellEditing();
        }
        super.columnMarginChanged(e);
    }

    public boolean shouldUseColoredCellRenderer() {
        return this.useColoredCellRenderer;
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int col) {
        if (this.useColoredCellRenderer) {
            Color color = null;
            CellColorProvider usedColorProvider = this.getCellColorProvider();
            if (usedColorProvider != null) {
                color = usedColorProvider.getCellColor(row, col);
            }
            if (color != null) {
                this.renderer.setColor(color);
            }
            this.renderer.setDateFormat(this.getDateFormat(row, col));
            if (col < this.maximalTextLengths.length) {
                this.renderer.setMaximalTextLength(this.maximalTextLengths[col]);
            }
            if (col < this.cutOnLineBreaks.length) {
                this.renderer.setCutOnFirstLineBreak(this.cutOnLineBreaks[col]);
            }
            return this.renderer;
        }
        return super.getCellRenderer(row, col);
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        Point p = e.getPoint();
        int colIndex = this.columnAtPoint(p);
        int rowIndex = this.rowAtPoint(p);
        return this.getToolTipText(colIndex, rowIndex);
    }

    protected String getToolTipText(int colIndex, int rowIndex) {
        int realColumnIndex = this.convertColumnIndexToModel(colIndex);
        String text = null;
        if (rowIndex >= 0 && rowIndex < this.getRowCount() && realColumnIndex >= 0 && realColumnIndex < this.getModel().getColumnCount()) {
            Object value = this.getModel().getValueAt(rowIndex, realColumnIndex);
            if (value instanceof Number) {
                Number number = (Number)value;
                double numberValue = number.doubleValue();
                text = Tools.formatIntegerIfPossible(numberValue);
            } else if (value != null) {
                if (value instanceof Date) {
                    int dateFormat = this.getDateFormat(rowIndex, realColumnIndex);
                    switch (dateFormat) {
                        case 0: {
                            text = Tools.formatDate((Date)value);
                            break;
                        }
                        case 1: {
                            text = Tools.formatTime((Date)value);
                            break;
                        }
                        case 2: {
                            text = Tools.formatDateTime((Date)value);
                            break;
                        }
                        default: {
                            text = value.toString();
                            break;
                        }
                    }
                } else {
                    text = value.toString();
                }
            } else {
                text = "?";
            }
        }
        if (text != null && !text.equals("")) {
            return SwingTools.transformToolTipText(text);
        }
        return super.getToolTipText();
    }

    @Override
    public String getCell(int row, int column) {
        Object value;
        String text = null;
        if (this.getTableHeader() != null) {
            if (row == 0) {
                return this.getTableHeader().getColumnModel().getColumn(column).getHeaderValue().toString();
            }
            --row;
        }
        if ((value = this.getModel().getValueAt(row, column)) instanceof Number) {
            Number number = (Number)value;
            double numberValue = number.doubleValue();
            text = Tools.formatIntegerIfPossible(numberValue);
        } else {
            text = value != null ? value.toString() : "?";
        }
        return text;
    }

    @Override
    public int getColumnNumber() {
        return this.getColumnCount();
    }

    @Override
    public int getRowNumber() {
        if (this.getTableHeader() != null) {
            return this.getRowCount() + 1;
        }
        return this.getRowCount();
    }

    @Override
    public void prepareReporting() {
    }

    @Override
    public void finishReporting() {
    }

    @Override
    public boolean isFirstLineHeader() {
        return false;
    }

    @Override
    public boolean isFirstColumnHeader() {
        return false;
    }

    public int getModelIndex(int rowIndex) {
        return this.tableSorter.modelIndex(rowIndex);
    }

    public void setExtendedScrollPane(ExtendedJScrollPane scrollPane) {
        this.scrollPaneParent = scrollPane;
    }

    public ExtendedJScrollPane getExtendedScrollPane() {
        return this.scrollPaneParent;
    }

    public void selectCompleteRow() {
        this.addColumnSelectionInterval(0, this.getColumnCount() - 1);
    }

    public void selectCompleteColumn() {
        this.addRowSelectionInterval(0, this.getRowCount() - 1);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.mouseReleased(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mouseReleased(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.showPopopUpMenu && e.isPopupTrigger()) {
            Point p = e.getPoint();
            int row = this.rowAtPoint(p);
            int c = this.columnAtPoint(p);
            int column = this.convertColumnIndexToModel(c);
            this.setRowSelectionInterval(row, row);
            this.setColumnSelectionInterval(column, column);
            JPopupMenu menu = this.createPopupMenu();
            menu.show(this, e.getX(), e.getY());
        }
    }

    public JPopupMenu createPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        this.populatePopupMenu(menu);
        return menu;
    }

    public void populatePopupMenu(JPopupMenu menu) {
        menu.add(this.ROW_ACTION);
        menu.add(this.COLUMN_ACTION);
        if (this.getTableHeader() != null) {
            menu.addSeparator();
            menu.add(this.FIT_COLUMN_ACTION);
            menu.add(this.FIT_ALL_COLUMNS_ACTION);
            menu.add(this.EQUAL_WIDTHS_ACTION);
        }
        if (this.isSortable()) {
            menu.addSeparator();
            menu.add(this.SORTING_ASCENDING_ACTION);
            menu.add(this.SORTING_DESCENDING_ACTION);
            menu.addSeparator();
            menu.add(this.ADD_TO_SORTING_ASCENDING_ACTION);
            menu.add(this.ADD_TO_SORTING_DESCENDING_ACTION);
        }
        if (this.getTableHeader() != null && this.getTableHeader().getReorderingAllowed()) {
            menu.addSeparator();
            menu.add(this.SORT_COLUMNS_BY_NAME_ACTION);
            menu.add(this.RESTORE_COLUMN_ORDER_ACTION);
            menu.add(this.generateMoveColumnMenu());
        }
    }

    private JMenu generateMoveColumnMenu() {
        ResourceMenu subMenu = new ResourceMenu("move_column_menu");
        int first = 0;
        if (this.fixFirstColumn) {
            first = 1;
        }
        for (int i = first; i < this.getColumnCount(); ++i) {
            subMenu.add(new MoveColumnAction(this, IconSize.SMALL, i));
        }
        return subMenu;
    }

    static /* synthetic */ boolean[] access$102(ExtendedJTable x0, boolean[] x1) {
        x0.cutOnLineBreaks = x1;
        return x1;
    }

    static /* synthetic */ int[] access$202(ExtendedJTable x0, int[] x1) {
        x0.maximalTextLengths = x1;
        return x1;
    }

    private class TableToolTipProvider
    implements ToolTipWindow.TipProvider {
        private TableToolTipProvider() {
        }

        @Override
        public Component getCustomComponent(Object id) {
            return null;
        }

        @Override
        public Object getIdUnder(Point point) {
            Pair<Integer, Integer> cellId = new Pair<Integer, Integer>(ExtendedJTable.this.columnAtPoint(point), ExtendedJTable.this.rowAtPoint(point));
            return cellId;
        }

        @Override
        public String getTip(Object id) {
            Pair cellId = (Pair)id;
            return ExtendedJTable.this.getToolTipText((Integer)cellId.getFirst(), (Integer)cellId.getSecond());
        }
    }
}

