/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import com.rapidminer.gui.tools.ExtendedListCellRenderer;
import com.rapidminer.gui.tools.ExtendedListModel;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import javax.swing.JList;

public class ExtendedJList
extends JList {
    public static final long serialVersionUID = 9032182018402L;
    private int preferredWidth = -1;

    public ExtendedJList(ExtendedListModel model) {
        this(model, -1);
    }

    public ExtendedJList(ExtendedListModel model, int preferredWidth) {
        super(model);
        this.setCellRenderer(new ExtendedListCellRenderer(model));
        this.preferredWidth = preferredWidth;
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        int index = this.locationToIndex(e.getPoint());
        return ((ExtendedListModel)this.getModel()).getToolTip(index);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        if (this.preferredWidth != -1) {
            if ((double)this.preferredWidth < dim.getWidth()) {
                return new Dimension(this.preferredWidth, (int)dim.getHeight());
            }
            return dim;
        }
        return dim;
    }
}

