/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import com.rapidminer.gui.look.fc.FileChooserUI;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Window;
import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;

public class ExtendedJFileChooser
extends JFileChooser {
    private static final long serialVersionUID = -3457903206380227482L;
    private final String i18nKey;
    private final Object[] i18nArgs;

    public ExtendedJFileChooser(File directory) {
        super(directory);
        this.i18nKey = null;
        this.i18nArgs = null;
    }

    public ExtendedJFileChooser(String i18nKey, File directory, Object ... i18nArgs) {
        super(directory);
        this.i18nKey = i18nKey;
        this.i18nArgs = i18nArgs;
    }

    @Override
    protected JDialog createDialog(Component parent) throws HeadlessException {
        JDialog dialog;
        if (this.i18nKey != null) {
            Window window = ExtendedJFileChooser.getWindowForComponent(parent);
            dialog = window instanceof Frame ? new FileChooserButtonDialog((Frame)window, this.i18nKey, true, this, this.i18nArgs) : new FileChooserButtonDialog((Dialog)window, this.i18nKey, true, this, this.i18nArgs);
        } else {
            boolean supportsWindowDecorations;
            String title = this.getUI().getDialogTitle(this);
            this.putClientProperty("AccessibleDescription", title);
            Window window = ExtendedJFileChooser.getWindowForComponent(parent);
            dialog = window instanceof Frame ? new JDialog((Frame)window, title, true) : new JDialog((Dialog)window, title, true);
            dialog.setComponentOrientation(this.getComponentOrientation());
            Container contentPane = dialog.getContentPane();
            contentPane.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            contentPane.add((Component)this, "Center");
            if (JDialog.isDefaultLookAndFeelDecorated() && (supportsWindowDecorations = UIManager.getLookAndFeel().getSupportsWindowDecorations())) {
                dialog.getRootPane().setWindowDecorationStyle(6);
            }
            dialog.pack();
            dialog.setLocationRelativeTo(parent);
        }
        return dialog;
    }

    private static Window getWindowForComponent(Component parentComponent) throws HeadlessException {
        if (parentComponent == null) {
            return JOptionPane.getRootFrame();
        }
        if (parentComponent instanceof Frame || parentComponent instanceof Dialog) {
            return (Window)parentComponent;
        }
        return ExtendedJFileChooser.getWindowForComponent(parentComponent.getParent());
    }

    private Collection<AbstractButton> getButtons() {
        LinkedList<AbstractButton> buttons = new LinkedList<AbstractButton>();
        if (this.getUI() instanceof FileChooserUI) {
            buttons.add(((FileChooserUI)this.getUI()).getApproveButton());
            buttons.add(((FileChooserUI)this.getUI()).getCancelButton());
        }
        return buttons;
    }

    public void addChangeListener(ChangeListener l) {
        if (this.getUI() instanceof FileChooserUI) {
            ((FileChooserUI)this.getUI()).addChangeListener(l);
        }
    }

    public void removeChangeListener(ChangeListener l) {
        if (this.getUI() instanceof FileChooserUI) {
            ((FileChooserUI)this.getUI()).removeChangeListener(l);
        }
    }

    public boolean isFileSelected() {
        if (this.getUI() instanceof FileChooserUI) {
            return ((FileChooserUI)this.getUI()).isFileSelected();
        }
        return true;
    }

    private class FileChooserButtonDialog
    extends ButtonDialog {
        private static final long serialVersionUID = -553876079090407051L;

        public FileChooserButtonDialog(Dialog owner, String key, boolean modal, ExtendedJFileChooser chooser, Object ... arguments) {
            super(owner, key, modal, arguments);
            chooser.setControlButtonsAreShown(false);
            this.layoutDefault((JComponent)chooser, 1, ExtendedJFileChooser.this.getButtons());
        }

        public FileChooserButtonDialog(Frame window, String key, boolean modal, ExtendedJFileChooser chooser, Object ... arguments) {
            super(window, key, modal, arguments);
            chooser.setControlButtonsAreShown(false);
            this.layoutDefault((JComponent)chooser, 1, ExtendedJFileChooser.this.getButtons());
        }
    }
}

