/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.accessibility.Accessible;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

public class ExtendedJComboBox
extends JComboBox {
    private static final long serialVersionUID = 8320969518243948543L;
    private boolean isScrollingToTopOnChange = false;
    private ListDataListener scrollToTopListener = new ListDataListener(){

        @Override
        public void intervalRemoved(ListDataEvent e) {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            if (ExtendedJComboBox.this.isScrollingToTopOnChange) {
                Accessible accessibleChild = ExtendedJComboBox.this.getUI().getAccessibleChild(ExtendedJComboBox.this, 0);
                if (!(accessibleChild instanceof JPopupMenu)) {
                    return;
                }
                Component scrollPaneObject = ((JPopupMenu)accessibleChild).getComponent(0);
                if (scrollPaneObject instanceof JScrollPane) {
                    ((JScrollPane)scrollPaneObject).getVerticalScrollBar().setValue(0);
                }
            }
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
        }
    };
    private int preferredWidth = -1;
    private int minimumWidth = -1;
    private boolean layingOut = false;
    private boolean wide = true;

    public ExtendedJComboBox(String[] values) {
        this(-1, -1, true, values);
    }

    public ExtendedJComboBox() {
        this(-1, -1);
    }

    public ExtendedJComboBox(int preferredWidth) {
        this(preferredWidth, -1);
    }

    public ExtendedJComboBox(int preferredWidth, int minimumWidth) {
        this(preferredWidth, minimumWidth, true);
    }

    public ExtendedJComboBox(int preferredWidth, int minimumWidth, boolean wide) {
        this(preferredWidth, minimumWidth, wide, new String[0]);
    }

    public ExtendedJComboBox(ComboBoxModel model) {
        this(-1, -1, true, model);
    }

    public ExtendedJComboBox(int preferredWidth, int minimumWidth, boolean wide, ComboBoxModel model) {
        super(model);
        this.preferredWidth = preferredWidth;
        this.minimumWidth = minimumWidth;
        this.wide = wide;
        model.addListDataListener(this.scrollToTopListener);
    }

    public ExtendedJComboBox(int preferredWidth, int minimumWidth, boolean wide, String[] values) {
        super(values);
        this.preferredWidth = preferredWidth;
        this.minimumWidth = minimumWidth;
        this.wide = wide;
        this.setRenderer(new ExtendedComboBoxRenderer());
    }

    public void setPreferredWidth(int preferredWidth) {
        this.preferredWidth = preferredWidth;
    }

    public void setModel(ComboBoxModel aModel) {
        super.setModel(aModel);
        aModel.addListDataListener(this.scrollToTopListener);
    }

    public boolean isScrollingToTopOnChange() {
        return this.isScrollingToTopOnChange;
    }

    public void enableScrollingToTopOnChange(boolean enable) {
        this.isScrollingToTopOnChange = enable;
    }

    public boolean isWide() {
        return this.wide;
    }

    public void setWide(boolean wide) {
        this.wide = wide;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        if (this.preferredWidth != -1) {
            return new Dimension(this.preferredWidth, (int)dim.getHeight());
        }
        return dim;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dim = super.getMinimumSize();
        if (this.minimumWidth != -1) {
            return new Dimension(this.minimumWidth, (int)dim.getHeight());
        }
        return dim;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doLayout() {
        try {
            this.layingOut = true;
            super.doLayout();
        }
        finally {
            this.layingOut = false;
        }
    }

    @Override
    public Dimension getSize() {
        Dimension dim = super.getSize();
        if (!this.layingOut && this.isWide()) {
            dim.width = Math.max(dim.width, super.getPreferredSize().width);
        }
        dim.width = Math.min(dim.width, Toolkit.getDefaultToolkit().getScreenSize().width - 40);
        return dim;
    }

    private static class ExtendedComboBoxRenderer
    extends BasicComboBoxRenderer {
        private static final long serialVersionUID = -6192190927539294311L;

        private ExtendedComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
                if (index >= 0) {
                    list.setToolTipText(value == null ? null : value.toString());
                }
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setFont(list.getFont());
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }
}

