/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import com.rapidminer.gui.tools.FrameIconProvider;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Tools;
import java.awt.Image;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.ImageIO;

public class DefaultFrameIconProvider
implements FrameIconProvider {
    private final String frameIconBaseName;

    public DefaultFrameIconProvider(String frameIconBaseName) {
        this.frameIconBaseName = frameIconBaseName;
    }

    @Override
    public List<Image> getFrameIcons() {
        try {
            LinkedList<Image> frameIcons = new LinkedList<Image>();
            for (String size : FRAME_ICON_SIZES) {
                URL url = Tools.getResource(this.frameIconBaseName + size + ".png");
                if (url == null) continue;
                frameIcons.add(ImageIO.read(url));
            }
            return frameIcons;
        }
        catch (IOException e) {
            LogService.getRoot().warning("Cannot load frame icons. Skipping...");
            return new LinkedList<Image>();
        }
    }
}

