/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import com.rapidminer.Process;
import com.rapidminer.ProcessLocation;
import com.rapidminer.gui.RapidMinerGUI;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;

public class ComponentPrinter
implements Printable {
    private Component component = null;
    private static final Font TITLE_FONT = new Font("LucidaSans", 0, 9);

    public ComponentPrinter(Component component) {
        this.component = component;
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) {
        ProcessLocation loc;
        if (pageIndex >= 1) {
            return 1;
        }
        String title = "RapidMiner";
        Process process = RapidMinerGUI.getMainFrame().getProcess();
        if (process != null && (loc = process.getProcessLocation()) != null) {
            title = title + ": " + loc.getShortName();
        }
        Rectangle2D rect = TITLE_FONT.getStringBounds(title, ((Graphics2D)g).getFontRenderContext());
        g.setFont(TITLE_FONT);
        g.drawString(title, (int)(pageFormat.getImageableX() + pageFormat.getImageableWidth() / 2.0 - rect.getWidth() / 2.0), (int)(pageFormat.getImageableY() - rect.getY()));
        Graphics2D translated = (Graphics2D)g.create((int)pageFormat.getImageableX(), (int)(pageFormat.getImageableY() + rect.getHeight() * 2.0), (int)pageFormat.getImageableWidth(), (int)(pageFormat.getImageableHeight() - rect.getHeight() * 2.0));
        double widthFactor = pageFormat.getImageableWidth() / (double)this.component.getWidth();
        double heightFactor = pageFormat.getImageableHeight() / (double)this.component.getHeight();
        double scaleFactor = Math.min(widthFactor, heightFactor);
        translated.scale(scaleFactor, scaleFactor);
        this.component.print(translated);
        translated.dispose();
        return 0;
    }
}

