/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import java.awt.Color;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public abstract class ColoredJTextPane
extends JTextPane {
    private static final long serialVersionUID = 1L;

    public ColoredJTextPane() {
        this.setDocument(new DefaultStyledDocument(){
            private static final long serialVersionUID = 1L;

            @Override
            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                super.insertString(offs, str, a);
                String text = this.getText(0, this.getLength());
                char[] chars = text.toCharArray();
                StyleContext context = StyleContext.getDefaultStyleContext();
                int lastStart = 0;
                boolean charactersSinceLastStart = false;
                for (int i = 0; i < text.length(); ++i) {
                    if (!Character.isLetter(chars[i])) {
                        if (charactersSinceLastStart) {
                            AttributeSet attributeSet = context.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.Foreground, ColoredJTextPane.this.getColor(new String(chars, lastStart, i - lastStart)));
                            this.setCharacterAttributes(lastStart, i - lastStart, attributeSet, true);
                        }
                        lastStart = i + 1;
                        charactersSinceLastStart = false;
                        continue;
                    }
                    charactersSinceLastStart = true;
                }
            }
        });
    }

    protected abstract Color getColor(String var1);
}

