/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;

public class CharTextField
extends JTextField {
    private static final long serialVersionUID = 2226618111016685226L;

    public CharTextField() {
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                CharTextField.this.setText(CharTextField.this.getText());
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                super.mouseReleased(e);
                CharTextField.this.selectAll();
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                CharTextField.this.selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
    }

    public CharTextField(char character) {
        this();
        this.setCharacter(character);
    }

    @Override
    public void setText(String text) {
        if (text.length() > 0) {
            super.setText(text.substring(text.length() - 1));
        }
        this.selectAll();
    }

    public void setCharacter(char character) {
        super.setText(String.valueOf(character));
        this.selectAll();
    }

    public char getCharacter() {
        return this.getText().charAt(0);
    }

    public boolean isSet() {
        return this.getText().length() > 0;
    }

    public void addChangeListener(ChangeListener l) {
    }
}

