/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import com.rapidminer.gui.tools.CellColorProvider;
import com.rapidminer.gui.tools.ExtendedJTable;
import java.awt.Color;

public class CellColorProviderScaled
implements CellColorProvider {
    private double min;
    private double max;
    private boolean absolute;
    private ExtendedJTable table;

    public CellColorProviderScaled(ExtendedJTable table, boolean absolute, double min, double max) {
        this.table = table;
        this.absolute = absolute;
        this.min = min;
        this.max = max;
    }

    @Override
    public Color getCellColor(int row, int column) {
        Object valueObject = this.table.getValueAt(row, column);
        try {
            double value = Double.parseDouble(valueObject.toString());
            if (!Double.isNaN(value)) {
                if (this.absolute) {
                    value = Math.abs(value);
                }
                float scaled = (float)((value - this.min) / (this.max - this.min));
                Color color = new Color(1.0f - scaled * 0.2f, 1.0f - scaled * 0.2f, 1.0f);
                return color;
            }
            return Color.WHITE;
        }
        catch (NumberFormatException e) {
            return Color.WHITE;
        }
    }
}

