/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class CamelCaseFilter {
    private final String filterString;
    private Pattern pattern = null;

    public CamelCaseFilter(String filterString) {
        if (filterString != null && filterString.trim().length() > 0) {
            StringBuilder regexp = new StringBuilder();
            filterString = filterString.trim();
            regexp.append(".*");
            regexp.append(filterString);
            regexp.append(".*|(");
            boolean first = true;
            for (char c : filterString.toCharArray()) {
                if (first || Character.isUpperCase(c) || Character.isDigit(c)) {
                    regexp.append(".*");
                }
                if (c == ' ') continue;
                if (first) {
                    regexp.append(Character.toUpperCase(c));
                } else {
                    regexp.append(c);
                }
                first = false;
            }
            regexp.append(".*)");
            try {
                this.pattern = Pattern.compile(regexp.toString());
            }
            catch (PatternSyntaxException e) {
                this.pattern = null;
            }
        }
        this.filterString = filterString.toLowerCase();
    }

    public boolean matches(String string) {
        if (string == null) {
            return false;
        }
        return string.toLowerCase().contains(this.filterString) || this.pattern != null && this.pattern.matcher(string).matches();
    }

    public String toString() {
        if (this.pattern != null) {
            return this.pattern.toString();
        }
        return this.filterString;
    }
}

