/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import com.rapidminer.gui.tools.ExtendedJComboBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Vector;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;

public class AutoCompletionComboBox
extends ExtendedJComboBox {
    private static final long serialVersionUID = 1L;
    private boolean caseSensitive;
    private final DocumentListener docListener = new AutoCompletionDocumentListener();

    public AutoCompletionComboBox(boolean wide, ComboBoxModel model) {
        this(false, -1, -1, wide, model);
    }

    public AutoCompletionComboBox(boolean caseSensitive, int preferredWidth, int preferredHeight, boolean wide, ComboBoxModel model) {
        super(preferredWidth, preferredHeight, wide, model);
        this.caseSensitive = caseSensitive;
        this.setEditable(true);
        this.setEditor(this.getEditor());
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                AutoCompletionComboBox.this.setSelectedItem(((JTextField)AutoCompletionComboBox.this.getEditor().getEditorComponent()).getText());
                AutoCompletionComboBox.this.actionPerformed(new ActionEvent(this, 0, "editingStopped"));
            }
        });
    }

    @Override
    public void setEditor(ComboBoxEditor anEditor) {
        if (this.getEditor() == null || anEditor.getEditorComponent() != this.getEditor().getEditorComponent()) {
            super.setEditor(new AutoCompletionComboBoxEditor(anEditor));
        }
    }

    @Override
    public synchronized void addFocusListener(FocusListener l) {
        for (Component c : this.getComponents()) {
            c.addFocusListener(l);
        }
    }

    @Override
    public void setSelectedItem(Object anObject) {
        super.setSelectedItem(anObject);
        this.getEditor().setItem(anObject);
    }

    private String checkForMatch(String givenString, Collection<String> collectionOfStrings, boolean caseSensitive) {
        if (givenString == null || collectionOfStrings == null) {
            return null;
        }
        String returnString = null;
        Collections.sort(new ArrayList<String>(collectionOfStrings));
        for (String vectorString : collectionOfStrings) {
            if (vectorString == null) continue;
            if (caseSensitive) {
                if (!vectorString.startsWith(givenString)) continue;
                returnString = vectorString;
                break;
            }
            if (!vectorString.toLowerCase(Locale.ENGLISH).startsWith(givenString.toLowerCase(Locale.ENGLISH))) continue;
            returnString = vectorString;
            break;
        }
        return returnString;
    }

    private final class AutoCompletionComboBoxEditor
    implements ComboBoxEditor {
        private JTextField editorComponent;
        private ComboBoxEditor editor;

        public AutoCompletionComboBoxEditor(ComboBoxEditor editor) {
            if (!(editor.getEditorComponent() instanceof JTextField)) {
                throw new IllegalArgumentException("Only JTextField allowed as editor component");
            }
            this.editor = editor;
            this.editorComponent = (JTextField)editor.getEditorComponent();
            this.editorComponent.getDocument().addDocumentListener(AutoCompletionComboBox.this.docListener);
            this.editorComponent.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        AutoCompletionComboBox.this.setSelectedItem(AutoCompletionComboBoxEditor.this.editorComponent.getText());
                        AutoCompletionComboBox.this.actionPerformed(new ActionEvent(this, 0, "editingStoped"));
                        e.consume();
                    } else if (e.getKeyCode() == 9) {
                        if (AutoCompletionComboBox.this.isPopupVisible()) {
                            AutoCompletionComboBox.this.hidePopup();
                        } else {
                            AutoCompletionComboBox.this.showPopup();
                        }
                        e.consume();
                    } else {
                        super.keyPressed(e);
                    }
                }
            });
        }

        @Override
        public void setItem(Object anObject) {
            this.editorComponent.getDocument().removeDocumentListener(AutoCompletionComboBox.this.docListener);
            this.editor.setItem(anObject);
            this.editorComponent.getDocument().addDocumentListener(AutoCompletionComboBox.this.docListener);
        }

        @Override
        public Object getItem() {
            return this.editor.getItem();
        }

        @Override
        public Component getEditorComponent() {
            return this.editorComponent;
        }

        @Override
        public void selectAll() {
            this.editor.selectAll();
        }

        @Override
        public void addActionListener(ActionListener l) {
            this.editor.addActionListener(l);
        }

        @Override
        public void removeActionListener(ActionListener l) {
            this.editor.removeActionListener(l);
        }
    }

    private final class AutoCompletionDocumentListener
    implements DocumentListener {
        private AutoCompletionDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            try {
                Vector<String> vectorOfStrings = new Vector<String>();
                for (int i = 0; i < AutoCompletionComboBox.this.getModel().getSize(); ++i) {
                    vectorOfStrings.add(String.valueOf(AutoCompletionComboBox.this.getModel().getElementAt(i)));
                }
                Document document = e.getDocument();
                String documentText = document.getText(0, document.getLength());
                String result = AutoCompletionComboBox.this.checkForMatch(documentText, vectorOfStrings, AutoCompletionComboBox.this.caseSensitive);
                final String newString = result == null ? documentText : result;
                final int startSelect = document.getLength();
                final int endSelect = newString.length();
                final JTextField editorComponent = (JTextField)AutoCompletionComboBox.this.getEditor().getEditorComponent();
                if (startSelect == e.getOffset() + e.getLength()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AutoCompletionComboBox.this.setSelectedItem(newString);
                            editorComponent.getDocument().removeDocumentListener(AutoCompletionComboBox.this.docListener);
                            editorComponent.setText(newString);
                            editorComponent.getDocument().addDocumentListener(AutoCompletionComboBox.this.docListener);
                            Caret caret = editorComponent.getCaret();
                            caret.setDot(endSelect);
                            caret.moveDot(startSelect);
                        }
                    });
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    }
}

