/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import javax.swing.Action;
import javax.swing.JButton;

public class ArrowButton
extends JButton {
    private static final long serialVersionUID = -355433594066885069L;
    private int direction = 3;

    public ArrowButton(int direction) {
        this.setText(" ");
        this.direction = direction;
    }

    public ArrowButton(Action a) {
        this(a, 3);
    }

    public ArrowButton(Action a, int direction) {
        super(a);
        this.setText(" ");
        this.direction = direction;
    }

    public void setDirection(int dir) {
        this.direction = dir;
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        GeneralPath arrow = new GeneralPath();
        switch (this.direction) {
            case 5: {
                int h = 2;
                int w = 4;
                arrow.moveTo(this.getWidth() / 2 - w, this.getHeight() / 2);
                arrow.lineTo(this.getWidth() / 2 + w, this.getHeight() / 2);
                arrow.lineTo(this.getWidth() / 2, this.getHeight() / 2 + 2 * h);
                arrow.closePath();
                break;
            }
            case 3: {
                int w = 2;
                int h = 4;
                arrow.moveTo(this.getWidth() / 2 - w, this.getHeight() / 2 - h);
                arrow.lineTo(this.getWidth() / 2 + w, this.getHeight() / 2);
                arrow.lineTo(this.getWidth() / 2 - w, this.getHeight() / 2 + h);
                arrow.closePath();
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal direction: " + this.direction);
            }
        }
        if (this.isEnabled()) {
            g.setColor(Color.BLACK);
        } else {
            g.setColor(Color.GRAY);
        }
        ((Graphics2D)g).fill(arrow);
    }
}

