/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.templates;

import com.rapidminer.gui.templates.Template;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ParameterService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TemplatesDialog
extends ButtonDialog {
    private static final long serialVersionUID = 1428487062393160289L;
    private final JList templateList = new JList();
    private final Map<String, Template> templateMap;
    protected final ExtendedJScrollPane listPane;
    protected final transient Action DELETE_ACTION;

    private void readUserTemplates() {
        File[] templateFiles = ParameterService.getUserRapidMinerDir().listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(".template");
            }
        });
        for (int i = 0; i < templateFiles.length; ++i) {
            try {
                Template template = new Template(templateFiles[i]);
                this.templateMap.put(template.getName(), template);
                continue;
            }
            catch (Exception e) {
                SwingTools.showSimpleErrorMessage("cannot_load_template_file", (Throwable)e, templateFiles[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readSystemTemplates() {
        InputStream in = TemplatesDialog.class.getResourceAsStream("/com/rapidminer/resources/templates/Templates");
        if (in == null) {
            LogService.getRoot().warning("Resource com/rapidminer/resources/templates/Templates not found.");
            return;
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    try {
                        String templateName = "/com/rapidminer/resources/templates/" + line.trim() + ".template";
                        InputStream tin = TemplatesDialog.class.getResourceAsStream(templateName);
                        if (tin != null) {
                            Template template = new Template(tin);
                            this.templateMap.put(template.getName(), template);
                            continue;
                        }
                        LogService.getRoot().warning("Cannot find template " + templateName);
                    }
                    catch (Exception e) {
                        SwingTools.showSimpleErrorMessage("cannot_load_template_file", (Throwable)e, line);
                    }
                }
                return;
            }
            catch (IOException e) {
                LogService.getRoot().log(Level.WARNING, "Error reading template list: " + e, e);
                return;
            }
        }
        catch (UnsupportedEncodingException e) {
            LogService.getRoot().warning("Resource /com/rapidminer/resources/templates/Templates cannot be read. UTF-8 not supported.");
            return;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public TemplatesDialog(int templateSource) {
        super("manage_templates", true, new Object[0]);
        this.templateList.setCellRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1496872314541527746L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof Template) {
                    Template template = (Template)value;
                    label.setText(template.getHTMLDescription());
                    label.setIcon(SwingTools.createIcon("16/package.png"));
                    label.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
                    label.setVerticalAlignment(1);
                    label.setVerticalTextPosition(1);
                    label.setHorizontalTextPosition(4);
                } else if (value instanceof String) {
                    label.setText("<html><strong>" + value.toString() + "</strong></html>");
                    label.setIcon(null);
                    label.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
                    label.setVerticalAlignment(1);
                    label.setVerticalTextPosition(1);
                    label.setHorizontalTextPosition(2);
                    label.setBackground(SwingTools.LIGHT_BLUE);
                }
                return label;
            }
        });
        this.templateList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!(TemplatesDialog.this.templateList.getSelectedValue() instanceof Template)) {
                    TemplatesDialog.this.templateList.setSelectedValue(null, false);
                }
                TemplatesDialog.this.fireStateChanged();
            }
        });
        this.templateMap = new TreeMap<String, Template>();
        this.listPane = new ExtendedJScrollPane(this.templateList);
        this.listPane.setBorder(TemplatesDialog.createBorder());
        this.DELETE_ACTION = new ResourceAction("delete_template", new Object[0]){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                TemplatesDialog.this.delete();
            }
        };
        switch (templateSource) {
            case 0: {
                this.readSystemTemplates();
                break;
            }
            case 1: {
                this.readUserTemplates();
                break;
            }
            default: {
                this.readSystemTemplates();
                this.readUserTemplates();
            }
        }
        this.update();
    }

    public JPanel createTemplateManagementPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.listPane, "Center");
        return panel;
    }

    private void update() {
        TreeMap<String, LinkedList<Template>> groupToTemplateList = new TreeMap<String, LinkedList<Template>>();
        for (Template template : this.templateMap.values()) {
            LinkedList<Template> groupList = (LinkedList<Template>)groupToTemplateList.get(template.getGroup());
            if (groupList == null) {
                groupList = new LinkedList<Template>();
                groupToTemplateList.put(template.getGroup(), groupList);
            }
            groupList.add(template);
        }
        Vector<Object> data = new Vector<Object>();
        for (Map.Entry entry : groupToTemplateList.entrySet()) {
            data.add(entry.getKey());
            for (Template template : (List)entry.getValue()) {
                data.add(template);
            }
        }
        this.templateList.setListData(data);
        this.repaint();
    }

    private void delete() {
        Object[] selection = this.templateList.getSelectedValues();
        for (int i = 0; i < selection.length; ++i) {
            String name = ((Template)selection[i]).getName();
            Template template = this.templateMap.remove(name);
            template.delete();
        }
        this.update();
    }

    public Template getSelectedTemplate() {
        Object selectedValue = this.templateList.getSelectedValue();
        if (selectedValue instanceof Template) {
            return (Template)selectedValue;
        }
        return null;
    }
}

