/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.templates;

import com.rapidminer.Process;
import com.rapidminer.gui.templates.OperatorParameterPair;
import com.rapidminer.io.process.XMLImporter;
import com.rapidminer.io.process.XMLTools;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ParameterService;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.XMLException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Template {
    public static final int PREDEFINED = 0;
    public static final int USER_DEFINED = 1;
    public static final int ALL = 2;
    private String name = "unnamed";
    private String description = "none";
    private String processResourceName;
    private Set<OperatorParameterPair> parameters = new TreeSet<OperatorParameterPair>();
    private File templateFile = null;
    private boolean readFromFile = false;
    private boolean oldFormat;
    private String group = "General";
    private String templateDefinition;

    public Template() {
    }

    public Template(File file) throws IOException, SAXException {
        this(new FileInputStream(file));
        this.readFromFile = true;
        this.templateFile = file;
    }

    public Template(InputStream ins) throws IOException, SAXException {
        if (!ins.markSupported()) {
            ins = new BufferedInputStream(ins);
        }
        ins.mark(7);
        String first = new String(new char[]{(char)ins.read(), (char)ins.read(), (char)ins.read(), (char)ins.read(), (char)ins.read()});
        ins.reset();
        if ("<?xml".equals(first)) {
            this.parseNewFormat(ins);
        } else {
            this.parseOldFormat(ins);
        }
    }

    private void parseNewFormat(InputStream ins) throws IOException, SAXException {
        this.oldFormat = false;
        this.templateDefinition = Tools.readTextFile(ins);
        Document doc = XMLTools.parse(new ByteArrayInputStream(this.templateDefinition.getBytes(XMLImporter.PROCESS_FILE_CHARSET)));
        this.name = XMLTools.getTagContents(doc.getDocumentElement(), "title");
        this.description = XMLTools.getTagContents(doc.getDocumentElement(), "description");
        this.group = XMLTools.getTagContents(doc.getDocumentElement(), "template-group");
        NodeList freeParameterElements = doc.getDocumentElement().getElementsByTagName("template-parameter");
        for (int i = 0; i < freeParameterElements.getLength(); ++i) {
            Element freeParameterElement = (Element)freeParameterElements.item(i);
            String operator = XMLTools.getTagContents(freeParameterElement, "operator");
            String parameterKey = XMLTools.getTagContents(freeParameterElement, "parameter");
            this.parameters.add(new OperatorParameterPair(operator, parameterKey));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseOldFormat(InputStream ins) throws IOException {
        this.oldFormat = true;
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader(ins, "UTF-8"));
            this.name = in.readLine();
            this.description = in.readLine();
            this.processResourceName = in.readLine();
            String line = null;
            while ((line = in.readLine()) != null) {
                String[] split = line.split("\\.");
                if (split.length == 2) {
                    this.parameters.add(new OperatorParameterPair(split[0], split[1]));
                    continue;
                }
                throw new IOException("Malformed operator parameter pair: " + line);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LogService.getRoot().log(Level.WARNING, "Cannot close stream to template file: " + e.getMessage(), e);
                }
            }
        }
    }

    public Template(String name, String group, String description, String configFile, Set<OperatorParameterPair> parameters) {
        this.name = name;
        this.group = group;
        this.description = description;
        this.processResourceName = configFile;
        this.parameters = parameters;
    }

    private InputStream getProcessStream() throws IOException {
        if (this.readFromFile) {
            return new FileInputStream(this.getProcessFile());
        }
        String resource = "/com/rapidminer/resources/templates/" + this.getProcessResource();
        InputStream resourceAsStream = Template.class.getResourceAsStream(resource);
        if (resourceAsStream == null) {
            throw new IOException("Resource " + resource + " not found.");
        }
        return resourceAsStream;
    }

    private File getProcessFile() {
        return new File(this.templateFile.getParent(), this.getProcessResource());
    }

    private String getProcessResource() {
        return this.processResourceName;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getGroup() {
        return this.group;
    }

    public Collection<OperatorParameterPair> getParameters() {
        return this.parameters;
    }

    public void saveAsUserTemplate(Process process) throws IOException, XMLException {
        String name = this.getName();
        File outputFile = ParameterService.getUserConfigFile(name + ".template");
        Document doc = process.getRootOperator().getDOMRepresentation();
        XMLTools.setTagContents(doc.getDocumentElement(), "title", this.getName());
        XMLTools.setTagContents(doc.getDocumentElement(), "description", this.getDescription());
        XMLTools.setTagContents(doc.getDocumentElement(), "template-group", this.getGroup());
        Element opps = doc.createElement("template-parameters");
        doc.getDocumentElement().appendChild(opps);
        for (OperatorParameterPair opp : this.parameters) {
            Element oppElement = doc.createElement("template-parameter");
            opps.appendChild(oppElement);
            XMLTools.setTagContents(oppElement, "operator", opp.getOperator());
            XMLTools.setTagContents(oppElement, "parameter", opp.getParameter());
        }
        XMLTools.stream(doc, outputFile, XMLImporter.PROCESS_FILE_CHARSET);
    }

    public void delete() {
        File expFile = this.getProcessFile();
        boolean deleteResult = this.templateFile.delete();
        if (!deleteResult) {
            LogService.getGlobal().logWarning("Unable to delete template file: " + this.templateFile);
        }
        if (!(deleteResult = expFile.delete())) {
            LogService.getGlobal().logWarning("Unable to delete template experiment file: " + expFile);
        }
    }

    public Process getProcess() throws IOException, XMLException {
        Process process;
        if (this.oldFormat) {
            InputStream in = this.getProcessStream();
            process = new Process(in);
        } else {
            process = new Process(this.templateDefinition);
        }
        String desc = process.getRootOperator().getUserDescription();
        if (desc == null || desc.isEmpty()) {
            process.getRootOperator().setUserDescription(this.getDescription());
        }
        return process;
    }

    public String getHTMLDescription() {
        return "<html><strong>" + this.getName() + "</strong>" + (this.readFromFile ? " <small>(user defined)</small>" : "") + "<div width=\"600\">" + this.getDescription() + "</div></html>";
    }
}

