/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.templates;

import com.rapidminer.Process;
import com.rapidminer.gui.templates.OperatorParameterPair;
import com.rapidminer.gui.templates.Template;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ResourceLabel;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.ParameterService;
import com.rapidminer.tools.Tools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class SaveAsTemplateDialog
extends ButtonDialog {
    private static final long serialVersionUID = -4892200177390173103L;
    private boolean ok = false;
    private final Set<OperatorParameterPair> selectedParameters = new HashSet<OperatorParameterPair>();
    private final JTextField nameField = new JTextField();
    private final JTextField groupField = new JTextField();
    private final JTextArea descriptionField = new JTextArea(5, 40);
    private Process process;

    public SaveAsTemplateDialog(Process process) {
        super("save_as_template", true, new Object[0]);
        this.process = process;
        this.descriptionField.setText(process.getRootOperator().getUserDescription());
        this.descriptionField.setLineWrap(true);
        this.descriptionField.setWrapStyleWord(true);
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        ResourceLabel label = new ResourceLabel("save_as_template.name", new Object[0]);
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = -1;
        c.insets = new Insets(0, 0, 6, 6);
        label.setLabelFor(this.nameField);
        panel.add((Component)label, c);
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 6, 0);
        c.fill = 1;
        panel.add((Component)this.nameField, c);
        label = new ResourceLabel("save_as_template.group", new Object[0]);
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = -1;
        c.insets = new Insets(0, 0, 6, 6);
        label.setLabelFor(this.groupField);
        panel.add((Component)label, c);
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 6, 0);
        c.fill = 1;
        panel.add((Component)this.groupField, c);
        label = new ResourceLabel("save_as_template.description", new Object[0]);
        c.insets = new Insets(0, 0, 6, 6);
        c.weightx = 0.0;
        c.gridwidth = -1;
        c.fill = 0;
        label.setLabelFor(this.descriptionField);
        panel.add((Component)label, c);
        c.weightx = 1.0;
        c.weighty = 0.1;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 6, 0);
        c.fill = 1;
        ExtendedJScrollPane descriptionPane = new ExtendedJScrollPane(this.descriptionField);
        descriptionPane.setBorder(SaveAsTemplateDialog.createBorder());
        panel.add((Component)descriptionPane, c);
        ExtendedJScrollPane tablePane = new ExtendedJScrollPane(this.makeCheckboxTable(process.getRootOperator()));
        tablePane.setBorder(SaveAsTemplateDialog.createBorder());
        c.weightx = 1.0;
        c.weighty = 0.9;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)tablePane, c);
        JButton okButton = this.makeOkButton();
        this.layoutDefault((JComponent)panel, 1, okButton, this.makeCancelButton());
        this.getRootPane().setDefaultButton(okButton);
    }

    private JComponent makeCheckboxTable(Operator operator) {
        LinkedList<Operator> ops = new LinkedList<Operator>();
        ops.add(operator);
        if (operator instanceof OperatorChain) {
            ops.addAll(((OperatorChain)operator).getAllInnerOperators());
        }
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 1;
        c.gridwidth = 0;
        for (Operator op : ops) {
            JPanel operatorPanel = new JPanel(new BorderLayout());
            Collection<ParameterType> parameterTypes = op.getParameters().getParameterTypes();
            if (parameterTypes.isEmpty()) continue;
            JLabel label = new JLabel("<html>" + op.getName() + "<br/><small>" + op.getOperatorDescription().getName() + "</small></html>");
            label.setIcon(op.getOperatorDescription().getSmallIcon());
            label.setPreferredSize(new Dimension(190, 50));
            label.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
            label.setVerticalAlignment(1);
            operatorPanel.add((Component)label, "West");
            int size = parameterTypes.size();
            GridLayout layout = new GridLayout(size, 2);
            layout.setHgap(6);
            layout.setVgap(6);
            JPanel parameterPanel = new JPanel(layout);
            for (ParameterType type : parameterTypes) {
                String current;
                final JCheckBox box = new JCheckBox(type.getKey());
                final OperatorParameterPair opp = new OperatorParameterPair(op.getName(), type.getKey());
                box.setSelected(false);
                parameterPanel.add(box);
                box.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (box.isSelected()) {
                            SaveAsTemplateDialog.this.selectedParameters.add(opp);
                        } else {
                            SaveAsTemplateDialog.this.selectedParameters.remove(opp);
                        }
                    }
                });
                try {
                    current = op.getParameterAsString(type.getKey());
                    if (current == null) {
                        current = "";
                    }
                }
                catch (UndefinedParameterError e1) {
                    current = "";
                }
                JLabel currentLabel = new JLabel(current);
                if (!current.equals(type.toString(type.getDefaultValue()))) {
                    currentLabel.setFont(currentLabel.getFont().deriveFont(1));
                    box.setSelected(true);
                    this.selectedParameters.add(opp);
                }
                parameterPanel.add(currentLabel);
            }
            operatorPanel.add((Component)parameterPanel, "Center");
            operatorPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.LIGHT_GRAY), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
            panel.add((Component)operatorPanel, c);
        }
        c.fill = 1;
        c.weighty = 1.0;
        panel.add((Component)new JPanel(new BorderLayout()), c);
        return panel;
    }

    private void addMandatoryParameters(Operator operator, Set<OperatorParameterPair> selectedOptional) {
        for (ParameterType type : operator.getParameters().getParameterTypes()) {
            if (type.isOptional() || operator.getParameters().isSet(type.getKey())) continue;
            selectedOptional.add(new OperatorParameterPair(operator.getName(), type.getKey()));
        }
        if (operator instanceof OperatorChain) {
            for (Operator child : ((OperatorChain)operator).getImmediateChildren()) {
                this.addMandatoryParameters(child, selectedOptional);
            }
        }
    }

    public boolean isOk() {
        return this.ok;
    }

    public Template getTemplate() {
        String name = this.nameField.getText();
        String group = this.groupField.getText();
        TreeSet<OperatorParameterPair> selectedOptional = new TreeSet<OperatorParameterPair>(new Comparator<OperatorParameterPair>(){

            @Override
            public int compare(OperatorParameterPair o1, OperatorParameterPair o2) {
                return o1.compareTo(o2);
            }
        });
        selectedOptional.addAll(this.selectedParameters);
        this.addMandatoryParameters(this.process.getRootOperator(), selectedOptional);
        return new Template(name, group, this.descriptionField.getText(), name + ".xml", selectedOptional);
    }

    private boolean checkIfNameOk() {
        String name = this.nameField.getText();
        if (name == null || name.length() == 0) {
            SwingTools.showVerySimpleErrorMessage("no_template_name", new Object[0]);
            return false;
        }
        File[] userDefinedTemplateFiles = ParameterService.getUserRapidMinerDir().listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(".template");
            }
        });
        for (int i = 0; i < userDefinedTemplateFiles.length; ++i) {
            String tempName = userDefinedTemplateFiles[i].getName().substring(0, userDefinedTemplateFiles[i].getName().lastIndexOf("."));
            if (!tempName.equals(name)) continue;
            SwingTools.showVerySimpleErrorMessage("Name '" + name + "' is already used." + Tools.getLineSeparator() + "Please change name or delete the old template!", new Object[0]);
            return false;
        }
        return true;
    }

    @Override
    protected void ok() {
        if (this.checkIfNameOk()) {
            this.ok = true;
            this.dispose();
        }
    }

    @Override
    protected void cancel() {
        this.ok = false;
        this.dispose();
    }
}

