/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.templates;

import com.rapidminer.gui.templates.BuildingBlock;
import com.rapidminer.gui.tools.ResourceLabel;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import com.rapidminer.io.process.XMLExporter;
import com.rapidminer.io.process.XMLImporter;
import com.rapidminer.io.process.XMLTools;
import com.rapidminer.operator.Operator;
import com.rapidminer.tools.ParameterService;
import com.rapidminer.tools.XMLException;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SaveAsBuildingBlockDialog
extends ButtonDialog {
    private static final long serialVersionUID = 7662184237558085856L;
    private boolean ok = false;
    private final JTextField nameField = new JTextField();
    private final JTextField descriptionField = new JTextField();

    public SaveAsBuildingBlockDialog(Operator operator) {
        super("save_building_block", true, new Object[0]);
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        ResourceLabel nameLabel = new ResourceLabel("save_building_block.name", new Object[0]);
        c.weightx = 0.0;
        c.gridwidth = -1;
        c.insets = new Insets(0, 0, 6, 6);
        panel.add((Component)nameLabel, c);
        this.nameField.setText(operator.getName());
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 6, 0);
        panel.add((Component)this.nameField, c);
        ResourceLabel descriptionLabel = new ResourceLabel("save_building_block.description", new Object[0]);
        c.insets = new Insets(0, 0, 0, 6);
        c.weightx = 0.0;
        c.gridwidth = -1;
        panel.add((Component)descriptionLabel, c);
        this.descriptionField.setText(operator.getUserDescription());
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)this.descriptionField, c);
        JButton okButton = this.makeOkButton();
        this.layoutDefault((JComponent)panel, okButton, this.makeCloseButton());
        this.getRootPane().setDefaultButton(okButton);
    }

    public boolean isOk() {
        return this.ok;
    }

    public BuildingBlock getBuildingBlock(Operator operator) {
        String name = this.nameField.getText();
        String xmlString = null;
        try {
            xmlString = XMLTools.toString(new XMLExporter().exportSingleOperator(operator), XMLImporter.PROCESS_FILE_CHARSET);
        }
        catch (XMLException e) {
            throw new RuntimeException("Cannot create process XML: " + e, e);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot create process XML: " + e, e);
        }
        return new BuildingBlock(name, this.descriptionField.getText(), operator.getOperatorDescription().getIconName(), xmlString, 2);
    }

    private boolean checkIfNameOk() {
        String name = this.nameField.getText();
        if (name == null || name.length() == 0) {
            SwingTools.showVerySimpleErrorMessage("no_template_name", new Object[0]);
            return false;
        }
        File[] userDefinedBuildingBlockFiles = ParameterService.getUserRapidMinerDir().listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(".buildingblock");
            }
        });
        for (int i = 0; i < userDefinedBuildingBlockFiles.length; ++i) {
            String tempName = userDefinedBuildingBlockFiles[i].getName().substring(0, userDefinedBuildingBlockFiles[i].getName().lastIndexOf("."));
            if (!tempName.equals(name)) continue;
            SwingTools.showVerySimpleErrorMessage("save_building_block.name_used", name);
            return false;
        }
        return true;
    }

    @Override
    protected void ok() {
        if (this.checkIfNameOk()) {
            this.ok = true;
            this.dispose();
        }
    }

    @Override
    protected void cancel() {
        this.ok = false;
        this.dispose();
    }
}

