/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.templates;

import com.rapidminer.Process;
import com.rapidminer.gui.actions.Actions;
import com.rapidminer.gui.templates.BuildingBlock;
import com.rapidminer.gui.tools.ResourceMenu;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.io.process.XMLImporter;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.UnknownParameterInformation;
import com.rapidminer.tools.BuildingBlockService;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.XMLException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.logging.Level;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class NewBuildingBlockMenu
extends ResourceMenu {
    private static final long serialVersionUID = 316102134905132452L;
    private final Actions actions;

    public NewBuildingBlockMenu(Actions actions) {
        super("new_building_block");
        this.actions = actions;
    }

    public void addAllMenuItems() {
        this.setMenuItems(BuildingBlockService.getBuildingBlocks());
    }

    public void setMenuItems(Collection<BuildingBlock> buildingBlocks) {
        this.removeAll();
        for (final BuildingBlock buildingBlock : buildingBlocks) {
            JMenuItem item = null;
            final String name = buildingBlock.getName();
            ImageIcon icon = buildingBlock.getSmallIcon();
            item = icon == null ? new JMenuItem(name) : new JMenuItem(name, icon);
            item.setToolTipText(buildingBlock.getDescription());
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String xmlDescription = buildingBlock.getXML();
                    try {
                        InputSource source = new InputSource(new StringReader(xmlDescription));
                        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(source);
                        Element element = document.getDocumentElement();
                        Operator operator = Operator.createFromXML(element, NewBuildingBlockMenu.this.actions.getProcess(), new LinkedList<UnknownParameterInformation>(), null, XMLImporter.CURRENT_VERSION);
                        NewBuildingBlockMenu.this.actions.insert(Collections.singletonList(operator));
                    }
                    catch (Exception ex) {
                        SwingTools.showSimpleErrorMessage("cannot_instantiate_building_block", (Throwable)ex, name);
                    }
                }
            });
            item.setEnabled(NewBuildingBlockMenu.checkBuildingBlock(buildingBlock));
            this.add(item);
        }
    }

    public static boolean checkBuildingBlock(BuildingBlock buildingBlock) {
        try {
            String xmlDescription = buildingBlock.getXML();
            InputSource source = new InputSource(new StringReader(xmlDescription));
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(source);
            Element element = document.getDocumentElement();
            Operator.createFromXML(element, new Process(), new LinkedList<UnknownParameterInformation>(), null, XMLImporter.CURRENT_VERSION);
            return true;
        }
        catch (IOException ex) {
            LogService.getRoot().log(Level.WARNING, "Cannot read building block: " + ex, ex);
            return false;
        }
        catch (SAXException e) {
            LogService.getRoot().log(Level.WARNING, "Cannot read building block: " + e, e);
            return false;
        }
        catch (ParserConfigurationException e) {
            LogService.getRoot().log(Level.WARNING, "Cannot read building block: " + e, e);
            return false;
        }
        catch (XMLException e) {
            LogService.getRoot().log(Level.WARNING, "Cannot read building block: " + e, e);
            return false;
        }
    }
}

