/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.templates;

import com.rapidminer.gui.templates.BuildingBlock;
import com.rapidminer.gui.templates.NewBuildingBlockMenu;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.FilterTextField;
import com.rapidminer.gui.tools.FilterableListModel;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import com.rapidminer.tools.BuildingBlockService;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.LogService;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.List;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;

public class BuildingBlockDialog
extends ButtonDialog {
    private static final long serialVersionUID = 4234757981716378086L;
    private static final Color SELECTED_COLOR = UIManager.getColor("Tree.selectionBackground");
    private static final Color TEXT_SELECTED_COLOR = UIManager.getColor("Tree.selectionForeground");
    private static final Color TEXT_NON_SELECTED_COLOR = UIManager.getColor("Tree.textForeground");
    private static final Icon ICON_USER_DEFINED = SwingTools.createIcon("16/" + I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.building_block.source.icon", new Object[0]));
    private static final String TOOLTIP_USER_DEFINED = I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.building_block.source.tip", new Object[0]);
    private boolean ok = false;
    protected final FilterableListModel listModel = new FilterableListModel();
    private final FilterableListModel.FilterCondition predefinedCondition = new FilterableListModel.FilterCondition(){

        @Override
        public boolean matches(Object o) {
            return ((BuildingBlock)o).isPredefined();
        }
    };
    private final FilterableListModel.FilterCondition userdefinedCondition = new FilterableListModel.FilterCondition(){

        @Override
        public boolean matches(Object o) {
            return ((BuildingBlock)o).isUserDefined();
        }
    };
    protected final JList buildingBlockList = new JList(this.listModel);
    protected final JScrollPane listPane;
    protected JPanel filterPanel;
    protected JPanel typePanel;

    public BuildingBlockDialog(String i18nKey) {
        this(i18nKey, 0);
    }

    public BuildingBlockDialog(String i18nKey, int buildingBlockSource) {
        super(i18nKey, true, new Object[0]);
        this.buildingBlockList.setCellRenderer(new DefaultListCellRenderer(){
            private final BuildingBlockPanel panel = new BuildingBlockPanel();
            private static final long serialVersionUID = 5546228931379122434L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                BuildingBlock buildingBlock = (BuildingBlock)value;
                this.panel.update(buildingBlock, isSelected, cellHasFocus);
                return this.panel;
            }

            final class BuildingBlockPanel
            extends JPanel {
                private static final long serialVersionUID = 514170387011803814L;
                private final JLabel label = new JLabel("");
                private final JLabel sourceIconLabel = new JLabel("");
                private boolean isSelected = false;

                private BuildingBlockPanel() {
                    this.setLayout(new BorderLayout());
                    this.setBackground(new Color(0, 0, 0, 0));
                    this.label.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
                    this.sourceIconLabel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 12));
                    this.sourceIconLabel.setToolTipText(TOOLTIP_USER_DEFINED);
                    this.add((Component)this.label, "Center");
                    this.add((Component)this.sourceIconLabel, "East");
                }

                public void update(BuildingBlock buildingBlock, boolean selected, boolean hasFocus) {
                    this.label.setText("<html>" + buildingBlock.getName() + "<br/><small>" + buildingBlock.getDescription() + "</small></html>");
                    this.label.setIcon(buildingBlock.getSmallIcon());
                    if (buildingBlock.isUserDefined()) {
                        this.sourceIconLabel.setIcon(ICON_USER_DEFINED);
                    } else {
                        this.sourceIconLabel.setIcon(null);
                    }
                    if (selected) {
                        this.label.setForeground(TEXT_SELECTED_COLOR);
                        this.sourceIconLabel.setForeground(TEXT_SELECTED_COLOR);
                    } else {
                        this.label.setForeground(TEXT_NON_SELECTED_COLOR);
                        this.sourceIconLabel.setForeground(TEXT_NON_SELECTED_COLOR);
                    }
                    this.isSelected = selected;
                }

                @Override
                public void paint(Graphics g) {
                    if (this.isSelected) {
                        g.setColor(SELECTED_COLOR);
                        g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    }
                    super.paint(g);
                }
            }
        });
        this.buildingBlockList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    BuildingBlockDialog.this.actOnDoubleClick();
                }
            }
        });
        this.buildingBlockList.setSelectionMode(0);
        this.listPane = new ExtendedJScrollPane(this.buildingBlockList);
        this.listPane.setBorder(BuildingBlockDialog.createBorder());
        this.filterPanel = new JPanel(new BorderLayout());
        ((BorderLayout)this.filterPanel.getLayout()).setHgap(0);
        ((BorderLayout)this.filterPanel.getLayout()).setVgap(0);
        final FilterTextField filter = new FilterTextField();
        filter.addFilterListener(this.listModel);
        this.filterPanel.add((Component)filter, "Center");
        JButton clearFilterButton = new JButton(new ResourceAction(true, "clear_filter", new Object[0]){
            private static final long serialVersionUID = -6347296002673216464L;

            @Override
            public void actionPerformed(ActionEvent e) {
                filter.clearFilter();
            }
        });
        clearFilterButton.setText(null);
        this.filterPanel.add((Component)clearFilterButton, "East");
        this.typePanel = new JPanel(new FlowLayout(0));
        ((FlowLayout)this.typePanel.getLayout()).setVgap(0);
        final JCheckBox predefinedCheckBox = new JCheckBox("Show predefined");
        predefinedCheckBox.setSelected(true);
        predefinedCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (predefinedCheckBox.isSelected()) {
                    BuildingBlockDialog.this.listModel.removeCondition(BuildingBlockDialog.this.predefinedCondition);
                } else {
                    BuildingBlockDialog.this.listModel.addCondition(BuildingBlockDialog.this.predefinedCondition);
                }
            }
        });
        this.typePanel.add(predefinedCheckBox);
        final JCheckBox userdefinedCheckBox = new JCheckBox("Show user defined");
        userdefinedCheckBox.setSelected(true);
        userdefinedCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (userdefinedCheckBox.isSelected()) {
                    BuildingBlockDialog.this.listModel.removeCondition(BuildingBlockDialog.this.userdefinedCondition);
                } else {
                    BuildingBlockDialog.this.listModel.addCondition(BuildingBlockDialog.this.userdefinedCondition);
                }
            }
        });
        this.typePanel.add(userdefinedCheckBox);
        List<BuildingBlock> buildingBlocks = null;
        switch (buildingBlockSource) {
            case 1: {
                buildingBlocks = BuildingBlockService.getPredefinedBuildingBlocks();
                break;
            }
            case 2: {
                buildingBlocks = BuildingBlockService.getUserBuildingBlocks();
                break;
            }
            case 3: {
                buildingBlocks = BuildingBlockService.getPluginBuildingBlocks();
                break;
            }
            default: {
                buildingBlocks = BuildingBlockService.getBuildingBlocks();
            }
        }
        for (BuildingBlock buildingBlock : buildingBlocks) {
            if (!NewBuildingBlockMenu.checkBuildingBlock(buildingBlock)) {
                LogService.getRoot().log(Level.WARNING, "Cannot initialize building block '" + buildingBlock.getName());
                continue;
            }
            this.listModel.addElement(buildingBlock);
        }
    }

    protected void actOnDoubleClick() {
        this.ok();
    }

    @Override
    protected void ok() {
        this.ok = true;
        this.dispose();
    }

    @Override
    protected void cancel() {
        this.ok = false;
        this.dispose();
    }

    public boolean isOk() {
        return this.ok;
    }

    public BuildingBlock getSelectedBuildingBlock() {
        return (BuildingBlock)this.buildingBlockList.getSelectedValue();
    }

    protected void delete() {
        int[] selectionIndices = this.buildingBlockList.getSelectedIndices();
        for (int i = selectionIndices.length - 1; i >= 0; --i) {
            BuildingBlock buildingBlock = (BuildingBlock)this.listModel.getElementAt(selectionIndices[i]);
            File buildingBlockFile = buildingBlock.getFile();
            if (buildingBlockFile == null) continue;
            boolean result = buildingBlockFile.delete();
            if (!result) {
                LogService.getGlobal().logWarning("Unable to delete building block file: " + buildingBlockFile);
                continue;
            }
            this.listModel.removeElementAt(selectionIndices[i]);
        }
    }
}

