/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.templates;

import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.tools.LogService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Level;
import javax.swing.ImageIcon;

public class BuildingBlock
implements Comparable<BuildingBlock> {
    public static final int ALL = 0;
    public static final int PREDEFINED = 1;
    public static final int USER_DEFINED = 2;
    public static final int PLUGIN_DEFINED = 3;
    private String name = "unnamed";
    private String description = "none";
    private String xmlDescription;
    private File buildingBlockFile;
    private String iconName;
    private int source = 1;

    @Deprecated
    public BuildingBlock(File file) throws InstantiationException {
        this(file, 1);
    }

    public BuildingBlock(File file, int source) throws InstantiationException {
        this.source = source;
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(file));
            this.init(in);
            this.buildingBlockFile = file;
        }
        catch (IOException e) {
            LogService.getRoot().log(Level.WARNING, "Cannot read building block file: " + e.getMessage(), e);
            throw new InstantiationException("Cannot instantiate building block: " + e.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LogService.getRoot().log(Level.WARNING, "Cannot close stream to building block file: " + e.getMessage(), e);
                }
            }
        }
    }

    @Deprecated
    public BuildingBlock(BufferedReader in) throws IOException {
        this(in, 1);
    }

    public BuildingBlock(BufferedReader in, int source) throws IOException {
        this.source = source;
        this.init(in);
    }

    @Deprecated
    public BuildingBlock(String name, String description, String iconPath, String xmlDescription) {
        this(name, description, iconPath, xmlDescription, 1);
    }

    public BuildingBlock(String name, String description, String iconName, String xmlDescription, int source) {
        this.name = name;
        this.description = description;
        this.iconName = iconName;
        this.xmlDescription = xmlDescription;
        this.source = source;
    }

    private void init(BufferedReader in) throws IOException {
        this.name = in.readLine();
        this.description = in.readLine();
        this.iconName = in.readLine();
        String line = null;
        StringBuffer result = new StringBuffer();
        while ((line = in.readLine()) != null) {
            result.append(line);
        }
        this.xmlDescription = result.toString();
    }

    public File getFile() {
        return this.buildingBlockFile;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getIconName() {
        return this.iconName;
    }

    public ImageIcon getSmallIcon() {
        return SwingTools.createIcon("16/" + this.getIconName());
    }

    public ImageIcon getLargeIcon() {
        return SwingTools.createIcon("24/" + this.getIconName());
    }

    public String getXML() {
        return this.xmlDescription;
    }

    public int getSource() {
        return this.source;
    }

    public boolean isUserDefined() {
        return this.source == 2;
    }

    public boolean isPredefined() {
        return this.source == 1;
    }

    public void save(File file) throws IOException {
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileWriter(file));
            out.println(this.name);
            out.println(this.description);
            out.println(this.iconName);
            out.println(this.xmlDescription);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(BuildingBlock buildingBlock) {
        return this.name.compareTo(buildingBlock.name);
    }

    public boolean equals(Object o) {
        if (!(o instanceof BuildingBlock)) {
            return false;
        }
        return this.name.equals(((BuildingBlock)o).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

