/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.renderer.weights;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.gui.renderer.AbstractDataTableTableRenderer;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeRegexp;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;

public class AttributeWeightsTableRenderer
extends AbstractDataTableTableRenderer {
    public static final String PARAMETER_ATTRIBUTE_SELECTION = "include_attributes";

    @Override
    public DataTable getDataTable(Object renderable, IOContainer ioContainer, boolean isRendering) {
        AttributeWeights weights = (AttributeWeights)renderable;
        if (!isRendering) {
            AttributeWeights clonedWeights = (AttributeWeights)weights.clone();
            try {
                Pattern pattern = Pattern.compile(this.getParameterAsString(PARAMETER_ATTRIBUTE_SELECTION));
                for (String attributeName : weights.getAttributeNames()) {
                    if (pattern.matcher(attributeName).matches()) continue;
                    clonedWeights.removeAttributeWeight(attributeName);
                }
            }
            catch (UndefinedParameterError e) {
                // empty catch block
            }
            return clonedWeights.createDataTable();
        }
        return weights.createDataTable();
    }

    @Override
    public List<ParameterType> getParameterTypes(InputPort inputPort) {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        types.add(new ParameterTypeRegexp(PARAMETER_ATTRIBUTE_SELECTION, "This regular expression is used to specify which attributes will be included in the weights table.", ".*"));
        return types;
    }
}

