/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.renderer.visualization;

import com.rapidminer.gui.plotter.Plotter;
import com.rapidminer.gui.plotter.PlotterAdapter;
import com.rapidminer.gui.plotter.PlotterConfigurationModel;
import com.rapidminer.gui.renderer.AbstractRenderer;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.visualization.LiftParetoChart;
import com.rapidminer.report.Reportable;
import java.awt.Component;

public class LiftChartRenderer
extends AbstractRenderer {
    @Override
    public String getName() {
        return "Plot";
    }

    private Plotter createLiftChartPlotter(Object renderable) {
        LiftParetoChart paretoChartInformation = (LiftParetoChart)renderable;
        PlotterConfigurationModel settings = new PlotterConfigurationModel("Pareto", paretoChartInformation.getLiftChartData());
        Plotter plotter = settings.getPlotter();
        settings.setParameterAsString("_axis_" + PlotterAdapter.transformParameterName(plotter.getAxisName(0)), settings.getDataTable().getColumnName(0));
        settings.setParameterAsString("_plot_column", settings.getDataTable().getColumnName(1));
        settings.setParameterAsString("count_value", paretoChartInformation.getTargetValue());
        settings.setParameterAsInt("sorting_direction", 0);
        settings.setParameterAsBoolean("show_bar_labels", paretoChartInformation.showBarLabels());
        settings.setParameterAsBoolean("show_cumulative_labels", paretoChartInformation.showCumulativeLabels());
        settings.setParameterAsBoolean("rotate_labels", paretoChartInformation.rotateLabels());
        return plotter;
    }

    @Override
    public Reportable createReportable(Object renderable, IOContainer ioContainer, int width, int height) {
        Plotter plotter = this.createLiftChartPlotter(renderable);
        plotter.getRenderComponent().setSize(width, height);
        return plotter;
    }

    @Override
    public Component getVisualizationComponent(Object renderable, IOContainer ioContainer) {
        return this.createLiftChartPlotter(renderable).getPlotter();
    }
}

