/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.renderer.similarity;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.gui.plotter.PlotterAdapter;
import com.rapidminer.gui.renderer.AbstractRenderer;
import com.rapidminer.gui.viewer.SimilarityKDistanceVisualization;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.similarity.SimilarityMeasureObject;
import com.rapidminer.report.Reportable;
import java.awt.Component;

public class SimilarityKDistanceRenderer
extends AbstractRenderer {
    @Override
    public String getName() {
        return "k-distances";
    }

    private PlotterAdapter createKDistancePlotter(SimilarityMeasureObject sim, ExampleSet exampleSet) {
        return new SimilarityKDistanceVisualization(sim.getDistanceMeasure(), exampleSet);
    }

    @Override
    public Reportable createReportable(Object renderable, IOContainer ioContainer, int width, int height) {
        SimilarityMeasureObject sim = (SimilarityMeasureObject)renderable;
        PlotterAdapter plotter = this.createKDistancePlotter(sim, sim.getExampleSet());
        plotter.getRenderComponent().setSize(width, height);
        return plotter;
    }

    @Override
    public Component getVisualizationComponent(Object renderable, IOContainer ioContainer) {
        SimilarityMeasureObject sim = (SimilarityMeasureObject)renderable;
        return this.createKDistancePlotter(sim, sim.getExampleSet());
    }
}

