/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.renderer.similarity;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.SimpleDataTable;
import com.rapidminer.datatable.SimpleDataTableRow;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.gui.plotter.Plotter;
import com.rapidminer.gui.plotter.PlotterConfigurationModel;
import com.rapidminer.gui.renderer.AbstractRenderer;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.similarity.SimilarityMeasureObject;
import com.rapidminer.report.Reportable;
import com.rapidminer.tools.math.similarity.DistanceMeasure;
import java.awt.Component;
import java.util.Random;

public class SimilarityHistogramRenderer
extends AbstractRenderer {
    @Override
    public String getName() {
        return "Histogram";
    }

    private Plotter createHistogramPlotter(SimilarityMeasureObject sim, ExampleSet exampleSet) {
        DistanceMeasure measure = sim.getDistanceMeasure();
        SimpleDataTable dataTable = new SimpleDataTable("Histogram", new String[]{"Histogram"});
        double sampleRatio = Math.min(1.0, 500.0 / (double)exampleSet.size());
        Random random = new Random();
        int i = 0;
        for (Example example : exampleSet) {
            int j = 0;
            for (Example comExample : exampleSet) {
                if (j != i && random.nextDouble() < sampleRatio) {
                    double simValue = measure.isDistance() ? measure.calculateDistance(example, comExample) : measure.calculateSimilarity(example, comExample);
                    dataTable.add(new SimpleDataTableRow(new double[]{simValue}));
                }
                ++j;
            }
            ++i;
        }
        PlotterConfigurationModel settings = new PlotterConfigurationModel("Histogram", (DataTable)dataTable);
        settings.enablePlotColumn(0);
        settings.setParameterAsInt("number_of_bins", 100);
        return settings.getPlotter();
    }

    @Override
    public Reportable createReportable(Object renderable, IOContainer ioContainer, int width, int height) {
        SimilarityMeasureObject sim = (SimilarityMeasureObject)renderable;
        Plotter plotter = this.createHistogramPlotter(sim, sim.getExampleSet());
        plotter.getRenderComponent().setSize(width, height);
        return plotter;
    }

    @Override
    public Component getVisualizationComponent(Object renderable, IOContainer ioContainer) {
        SimilarityMeasureObject sim = (SimilarityMeasureObject)renderable;
        Plotter plotter = this.createHistogramPlotter(sim, sim.getExampleSet());
        return plotter.getPlotter();
    }
}

