/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.renderer.performance;

import com.rapidminer.gui.renderer.AbstractRenderer;
import com.rapidminer.gui.tools.ExtendedHTMLJEditorPane;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.validation.significance.TTestSignificanceTestOperator;
import com.rapidminer.report.Readable;
import com.rapidminer.report.Reportable;
import com.rapidminer.tools.Tools;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;

public class TTestSignificanceTestRenderer
extends AbstractRenderer {
    @Override
    public Reportable createReportable(Object renderable, IOContainer ioContainer, int desiredWidth, int desiredHeight) {
        return (Readable)renderable;
    }

    @Override
    public String getName() {
        return "T-Test Significance";
    }

    @Override
    public Component getVisualizationComponent(Object renderable, IOContainer ioContainer) {
        int i;
        TTestSignificanceTestOperator.TTestSignificanceTestResult result = (TTestSignificanceTestOperator.TTestSignificanceTestResult)renderable;
        PerformanceVector[] allVectors = result.getAllVectors();
        StringBuffer buffer = new StringBuffer();
        Color bgColor = SwingTools.LIGHTEST_YELLOW;
        String bgColorString = Integer.toHexString(bgColor.getRed()) + Integer.toHexString(bgColor.getGreen()) + Integer.toHexString(bgColor.getBlue());
        buffer.append("<table bgcolor=\"" + bgColorString + "\" border=\"1\">");
        buffer.append("<tr><td></td>");
        for (i = 0; i < result.getAllVectors().length; ++i) {
            buffer.append("<td>" + Tools.formatNumber(allVectors[i].getMainCriterion().getAverage()) + " +/- " + Tools.formatNumber(Math.sqrt(allVectors[i].getMainCriterion().getVariance())) + "</td>");
        }
        buffer.append("</tr>");
        for (i = 0; i < allVectors.length; ++i) {
            buffer.append("<tr><td>" + Tools.formatNumber(allVectors[i].getMainCriterion().getAverage()) + " +/- " + Tools.formatNumber(Math.sqrt(allVectors[i].getMainCriterion().getVariance())) + "</td>");
            for (int j = 0; j < allVectors.length; ++j) {
                buffer.append("<td>");
                if (!Double.isNaN(result.getProbMatrix()[i][j])) {
                    double prob = result.getProbMatrix()[i][j];
                    if (prob < result.getAlpha()) {
                        buffer.append("<b>");
                    }
                    buffer.append(Tools.formatNumber(prob));
                    if (prob < result.getAlpha()) {
                        buffer.append("</b>");
                    }
                }
                buffer.append("</td>");
            }
            buffer.append("</tr>");
        }
        buffer.append("</table>");
        buffer.append("<br>Probabilities for random values with the same result.<br>Bold values are smaller than alpha=" + Tools.formatNumber(result.getAlpha()) + " which indicates a probably significant difference between the actual mean values!");
        ExtendedHTMLJEditorPane textPane = new ExtendedHTMLJEditorPane("text/html", "<html><h1>" + this.getName() + "</h1>" + buffer.toString() + "</html>");
        textPane.setBackground(new JLabel().getBackground());
        textPane.setBorder(BorderFactory.createEmptyBorder(11, 11, 11, 11));
        textPane.setEditable(false);
        return new ExtendedJScrollPane(textPane);
    }
}

