/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.renderer.performance;

import com.rapidminer.gui.renderer.AbstractRenderer;
import com.rapidminer.gui.viewer.PerformanceVectorViewer;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.performance.PerformanceCriterion;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.report.Reportable;
import java.awt.Component;
import java.util.List;

public class PerformanceVectorRenderer
extends AbstractRenderer {
    private static final String PARAMETER_CRITERION = "criterion";

    @Override
    public String getName() {
        return "Table / Plot View";
    }

    @Override
    public Reportable createReportable(Object renderable, IOContainer ioContainer, int desiredWidth, int desiredHeight) {
        PerformanceVector performanceVector = (PerformanceVector)renderable;
        String criterionName = null;
        try {
            criterionName = this.getParameterAsString(PARAMETER_CRITERION);
        }
        catch (UndefinedParameterError e) {
            // empty catch block
        }
        PerformanceCriterion criterion = null;
        if (criterionName != null) {
            criterion = performanceVector.getCriterion(criterionName);
        }
        if (criterion == null) {
            criterion = performanceVector.getMainCriterion();
        }
        return criterion;
    }

    @Override
    public Component getVisualizationComponent(Object renderable, IOContainer ioContainer) {
        PerformanceVector performanceVector = (PerformanceVector)renderable;
        return new PerformanceVectorViewer(performanceVector, ioContainer);
    }

    @Override
    public List<ParameterType> getParameterTypes(InputPort inputPort) {
        List<ParameterType> types = super.getParameterTypes(inputPort);
        types.add(new ParameterTypeString(PARAMETER_CRITERION, "Indicates which criterion should be reported (empty: use main criterion).", true));
        return types;
    }
}

