/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.renderer.models;

import com.rapidminer.datatable.AbstractDataTable;
import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableRow;
import com.rapidminer.gui.renderer.AbstractDataTableTableRenderer;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.learner.local.LocalPolynomialRegressionModel;
import java.util.Iterator;

public class LocalPolynomialRegressionModelTableRenderer
extends AbstractDataTableTableRenderer {
    @Override
    public DataTable getDataTable(Object renderable, IOContainer ioContainer, boolean isRendering) {
        LocalPolynomialRegressionModel model = (LocalPolynomialRegressionModel)renderable;
        return new LocalPolynomialRegressionModelDataTable("Training Data", model);
    }

    @Override
    public boolean isAutoresize() {
        return false;
    }

    public static class LocalPolynomialRegressionModelDataTable
    extends AbstractDataTable {
        private LocalPolynomialRegressionModel model;

        public LocalPolynomialRegressionModelDataTable(String name, LocalPolynomialRegressionModel model) {
            super(name);
            this.model = model;
        }

        @Override
        public void add(DataTableRow row) {
        }

        @Override
        public int getColumnIndex(String name) {
            if (name.equals("Label")) {
                return 0;
            }
            if (name.equals("Weight")) {
                return 1;
            }
            int i = 2;
            for (String attrName : this.model.getAttributeNames()) {
                if (attrName.equals(name)) {
                    return i;
                }
                ++i;
            }
            return 0;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return "Label";
            }
            if (column == 1) {
                return "Weight";
            }
            return this.model.getAttributeNames()[column - 2];
        }

        @Override
        public double getColumnWeight(int i) {
            return 1.0;
        }

        @Override
        public int getNumberOfColumns() {
            if (this.model.getSamples().size() > 0) {
                LocalPolynomialRegressionModel.RegressionData data = this.model.getSamples().get(0);
                return data.getExampleValues().length + 2;
            }
            return 0;
        }

        @Override
        public int getNumberOfRows() {
            return this.model.getSamples().size();
        }

        @Override
        public int getNumberOfSpecialColumns() {
            return 0;
        }

        @Override
        public int getNumberOfValues(int column) {
            return 0;
        }

        @Override
        public DataTableRow getRow(final int index) {
            return new DataTableRow(){

                @Override
                public String getId() {
                    return index + "";
                }

                @Override
                public int getNumberOfValues() {
                    LocalPolynomialRegressionModel.RegressionData data = LocalPolynomialRegressionModelDataTable.this.model.getSamples().get(index);
                    return data.getExampleValues().length + 2;
                }

                @Override
                public double getValue(int columnIndex) {
                    LocalPolynomialRegressionModel.RegressionData data = LocalPolynomialRegressionModelDataTable.this.model.getSamples().get(index);
                    if (columnIndex == 0) {
                        return data.getExampleLabel();
                    }
                    if (columnIndex == 1) {
                        return data.getExampleWeight();
                    }
                    return data.getExampleValues()[columnIndex - 2];
                }
            };
        }

        @Override
        public boolean isDate(int index) {
            return false;
        }

        @Override
        public boolean isDateTime(int index) {
            return false;
        }

        @Override
        public boolean isNominal(int index) {
            return false;
        }

        @Override
        public boolean isNumerical(int index) {
            return true;
        }

        @Override
        public boolean isSpecial(int column) {
            return false;
        }

        @Override
        public boolean isSupportingColumnWeights() {
            return false;
        }

        @Override
        public boolean isTime(int index) {
            return false;
        }

        @Override
        public Iterator<DataTableRow> iterator() {
            return new Iterator<DataTableRow>(){
                private int rowIndex = 0;

                @Override
                public boolean hasNext() {
                    return this.rowIndex < LocalPolynomialRegressionModelDataTable.this.getNumberOfRows();
                }

                @Override
                public DataTableRow next() {
                    DataTableRow row = LocalPolynomialRegressionModelDataTable.this.getRow(this.rowIndex);
                    ++this.rowIndex;
                    return row;
                }

                @Override
                public void remove() {
                }
            };
        }

        @Override
        public String mapIndex(int column, int index) {
            return "";
        }

        @Override
        public int mapString(int column, String value) {
            return 0;
        }

        @Override
        public DataTable sample(int newSize) {
            return this;
        }
    }
}

