/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.renderer.models;

import com.rapidminer.gui.renderer.AbstractTableModelTableRenderer;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.learner.functions.LinearRegressionModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class LinearRegressionModelTableRenderer
extends AbstractTableModelTableRenderer {
    @Override
    public TableModel getTableModel(Object renderable, IOContainer ioContainer, boolean isReporting) {
        return new LinearRegressionModelTableModel((LinearRegressionModel)renderable);
    }

    private static class LinearRegressionModelTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -2112928170124291591L;
        private final LinearRegressionModel model;

        public LinearRegressionModelTableModel(LinearRegressionModel model) {
            this.model = model;
        }

        @Override
        public int getColumnCount() {
            return 6;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return String.class;
                }
            }
            return Double.class;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "Attribute";
                }
                case 1: {
                    return "Coefficient";
                }
                case 2: {
                    return "Std. Error";
                }
                case 3: {
                    return "Std. Coefficient";
                }
                case 4: {
                    return "t-Stat";
                }
                case 5: {
                    return "Significance";
                }
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return this.model.getCoefficients().length - (this.model.usesIntercept() ? 0 : 1);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    if (this.model.usesIntercept() && rowIndex == this.model.getCoefficients().length - 1) {
                        return "(Intercept)";
                    }
                    return this.model.getSelectedAttributeNames()[rowIndex];
                }
                case 1: {
                    return this.model.getCoefficients()[rowIndex];
                }
                case 2: {
                    if (this.model.usesIntercept() && rowIndex == this.model.getCoefficients().length - 1) {
                        return 0;
                    }
                    return this.model.getStandardErrors()[rowIndex];
                }
                case 3: {
                    if (this.model.usesIntercept() && rowIndex == this.model.getCoefficients().length - 1) {
                        return 0;
                    }
                    return this.model.getStandardizedCoefficients()[rowIndex];
                }
                case 4: {
                    if (this.model.usesIntercept() && rowIndex == this.model.getCoefficients().length - 1) {
                        return 0;
                    }
                    return this.model.getTStats()[rowIndex];
                }
                case 5: {
                    if (this.model.usesIntercept() && rowIndex == this.model.getCoefficients().length - 1) {
                        return 0;
                    }
                    return this.model.getProbabilities()[rowIndex];
                }
            }
            return null;
        }
    }
}

