/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.renderer.models;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.SimpleDataTable;
import com.rapidminer.datatable.SimpleDataTableRow;
import com.rapidminer.gui.plotter.Plotter;
import com.rapidminer.gui.plotter.PlotterConfigurationModel;
import com.rapidminer.gui.renderer.AbstractRenderer;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.features.transformation.AbstractEigenvectorModel;
import com.rapidminer.report.Reportable;
import java.awt.Component;

public class EigenvectorModelVariancePlotRenderer
extends AbstractRenderer {
    @Override
    public Reportable createReportable(Object renderable, IOContainer ioContainer, int desiredWidth, int desiredHeight) {
        return this.getPlotter(renderable);
    }

    @Override
    public String getName() {
        return "Cumulative Variance Plot";
    }

    @Override
    public Component getVisualizationComponent(Object renderable, IOContainer ioContainer) {
        return this.getPlotter(renderable).getPlotter();
    }

    private Plotter getPlotter(Object renderable) {
        AbstractEigenvectorModel model = (AbstractEigenvectorModel)renderable;
        double[] cumulativeVariance = model.getCumulativeVariance();
        SimpleDataTable dataTable = new SimpleDataTable("Cumulative Proportion of Variance", new String[]{"Principal Components", "Cumulative Proportion of Variance"});
        dataTable.add(new SimpleDataTableRow(new double[]{0.0, 0.0}));
        for (int i = 0; i < cumulativeVariance.length; ++i) {
            dataTable.add(new SimpleDataTableRow(new double[]{i + 1, cumulativeVariance[i]}));
        }
        PlotterConfigurationModel settings = new PlotterConfigurationModel(PlotterConfigurationModel.WEIGHT_PLOTTER_SELECTION, (DataTable)dataTable);
        settings.setPlotter("Lines");
        Plotter plotter = settings.getPlotter();
        settings.setAxis(0, 0);
        settings.enablePlotColumn(1);
        return plotter;
    }
}

