/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.renderer.models;

import com.rapidminer.gui.renderer.AbstractTableModelTableRenderer;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.features.transformation.AbstractEigenvectorModel;
import com.rapidminer.operator.features.transformation.ComponentVector;
import com.rapidminer.tools.Tools;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class EigenvectorModelEigenvectorRenderer
extends AbstractTableModelTableRenderer {
    @Override
    public String getName() {
        return "Eigenvectors";
    }

    @Override
    public TableModel getTableModel(Object renderable, IOContainer ioContainer, boolean isReporting) {
        AbstractEigenvectorModel model = (AbstractEigenvectorModel)renderable;
        return model.getEigenvectorTableModel();
    }

    public static class EigenvectorTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -9026248524043239399L;
        private String[] attributeNames;
        private List<? extends ComponentVector> eigenVectors;
        private int numberOfComponents;

        public EigenvectorTableModel(List<? extends ComponentVector> eigenVectors, String[] attributeNames, int numberOfComponents) {
            this.eigenVectors = eigenVectors;
            this.attributeNames = attributeNames;
            this.numberOfComponents = numberOfComponents;
        }

        @Override
        public int getColumnCount() {
            return this.eigenVectors.size() + 1;
        }

        @Override
        public int getRowCount() {
            return this.numberOfComponents;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return this.attributeNames[rowIndex];
            }
            return Tools.formatNumber(this.eigenVectors.get(columnIndex - 1).getVector()[rowIndex]);
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return "Attribute";
            }
            return "PC " + column;
        }
    }
}

