/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.renderer.models;

import com.rapidminer.gui.renderer.AbstractTableModelTableRenderer;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.features.transformation.AbstractEigenvectorModel;
import com.rapidminer.operator.features.transformation.ComponentVector;
import com.rapidminer.tools.Tools;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class EigenvectorModelEigenvalueRenderer
extends AbstractTableModelTableRenderer {
    @Override
    public String getName() {
        return "Eigenvalues";
    }

    @Override
    public TableModel getTableModel(Object renderable, IOContainer ioContainer, boolean isReporting) {
        AbstractEigenvectorModel model = (AbstractEigenvectorModel)renderable;
        return model.getEigenvalueTableModel();
    }

    public static class EigenvalueTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -9026248524043239399L;
        private double varianceSum;
        private double[] cumulativeVariance;
        private List<? extends ComponentVector> eigenVectors;

        public EigenvalueTableModel(List<? extends ComponentVector> eigenVectors, double[] cumulativeVariance, double varianceSum) {
            this.eigenVectors = eigenVectors;
            this.cumulativeVariance = cumulativeVariance;
            this.varianceSum = varianceSum;
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return this.eigenVectors.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "PC " + (rowIndex + 1);
                }
                case 1: {
                    return Tools.formatNumber(Math.sqrt(this.eigenVectors.get(rowIndex).getEigenvalue()));
                }
                case 2: {
                    return Tools.formatNumber(this.eigenVectors.get(rowIndex).getEigenvalue() / this.varianceSum);
                }
                case 3: {
                    return Tools.formatNumber(this.cumulativeVariance[rowIndex]);
                }
            }
            return "unknown";
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Component";
                }
                case 1: {
                    return "Standard Deviation";
                }
                case 2: {
                    return "Proportion of Variance";
                }
                case 3: {
                    return "Cumulative Variance";
                }
            }
            return "unknown";
        }
    }
}

