/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.renderer.models;

import com.rapidminer.gui.renderer.AbstractTableModelTableRenderer;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.learner.bayes.DistributionModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class DistributionModelTableRenderer
extends AbstractTableModelTableRenderer {
    @Override
    public TableModel getTableModel(Object renderable, IOContainer ioContainer, boolean isReporting) {
        DistributionModel distributionModel = (DistributionModel)renderable;
        if (distributionModel != null) {
            return new DistributionTableModel(distributionModel);
        }
        return null;
    }

    @Override
    public String getName() {
        return "Distribution Table";
    }

    @Override
    public boolean isAutoresize() {
        return false;
    }

    private static class DistributionTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 2196512073454635516L;
        private DistributionModel model;
        private int totalNumberOfParameters = 0;
        private int[] rowDistributionIndices;
        private int[] rowParameterIndices;

        public DistributionTableModel(DistributionModel model) {
            this.model = model;
            for (int i = 0; i < model.getNumberOfAttributes(); ++i) {
                this.totalNumberOfParameters += model.getDistribution(0, i).getNumberOfParameters();
            }
            this.rowDistributionIndices = new int[this.totalNumberOfParameters];
            this.rowParameterIndices = new int[this.totalNumberOfParameters];
            int row = 0;
            for (int i = 0; i < model.getNumberOfAttributes(); ++i) {
                int j = 0;
                while (j < model.getDistribution(0, i).getNumberOfParameters()) {
                    this.rowDistributionIndices[row] = i;
                    this.rowParameterIndices[row] = j++;
                    ++row;
                }
            }
        }

        @Override
        public int getColumnCount() {
            return this.model.getNumberOfClasses() + 2;
        }

        @Override
        public int getRowCount() {
            return this.totalNumberOfParameters;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.model.getAttributeNames()[this.rowDistributionIndices[rowIndex]];
                }
                case 1: {
                    return this.model.getDistribution(0, this.rowDistributionIndices[rowIndex]).getParameterName(this.rowParameterIndices[rowIndex]);
                }
            }
            return this.model.getDistribution(columnIndex - 2, this.rowDistributionIndices[rowIndex]).getParameterValue(this.rowParameterIndices[rowIndex]);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return String.class;
            }
            if (columnIndex == 1) {
                return String.class;
            }
            return Double.class;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "Attribute";
            }
            if (columnIndex == 1) {
                return "Parameter";
            }
            return this.model.getClassName(columnIndex - 2);
        }
    }
}

