/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.renderer.models;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.SimpleDataTable;
import com.rapidminer.gui.plotter.PlotterAdapter;
import com.rapidminer.gui.plotter.PlotterConfigurationModel;
import com.rapidminer.gui.plotter.charts.DistributionPlotter;
import com.rapidminer.gui.plotter.settings.ListeningJComboBox;
import com.rapidminer.gui.renderer.AbstractRenderer;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.learner.bayes.DistributionModel;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.ParameterTypeTupel;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.report.Reportable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DistributionModelPlotRenderer
extends AbstractRenderer {
    public static final String PARAMETER_ATTRIBUTE_NAME = "attribute_name";
    public static final String PARAMETER_ROTATE_LABELS = "rotate_labels";
    public static final String PARAMETER_RANGE = "range_";
    public static final String PARAMETER_RANGE_MIN = "range_min";
    public static final String PARAMETER_RANGE_MAX = "range_max";

    @Override
    public String getName() {
        return "Plot View";
    }

    @Override
    public Reportable createReportable(Object renderable, IOContainer ioContainer, int width, int height) {
        DistributionModel distributionModel = (DistributionModel)renderable;
        String attributeName = "";
        String range = null;
        try {
            attributeName = this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME);
            range = this.getParameterAsString(PARAMETER_RANGE);
        }
        catch (UndefinedParameterError e) {
            // empty catch block
        }
        boolean rotateLabels = this.getParameterAsBoolean(PARAMETER_ROTATE_LABELS);
        SimpleDataTable table = new SimpleDataTable("Dummy", distributionModel.getAttributeNames());
        PlotterConfigurationModel settings = new PlotterConfigurationModel(PlotterConfigurationModel.COMPLETE_PLOTTER_SELECTION, (DataTable)table);
        DistributionPlotter plotter = new DistributionPlotter(settings, distributionModel);
        settings.setPlotter(plotter);
        settings.setParameterAsString("_plot_column", attributeName);
        settings.setParameterAsBoolean(PARAMETER_ROTATE_LABELS, rotateLabels);
        if (range != null) {
            String rangeList = ParameterTypeList.transformList2String(Collections.singletonList(new String[]{"Value", range}));
            settings.setParameterAsString("range_list", rangeList);
        }
        plotter.getRenderComponent().setSize(width, height);
        return plotter;
    }

    @Override
    public Component getVisualizationComponent(Object renderable, IOContainer ioContainer) {
        DistributionModel distributionModel = (DistributionModel)renderable;
        JPanel graphPanel = new JPanel(new BorderLayout());
        SimpleDataTable table = new SimpleDataTable("Dummy", distributionModel.getAttributeNames());
        final PlotterConfigurationModel settings = new PlotterConfigurationModel(PlotterConfigurationModel.COMPLETE_PLOTTER_SELECTION, (DataTable)table);
        DistributionPlotter plotter = new DistributionPlotter(settings, distributionModel);
        settings.setPlotter(plotter);
        graphPanel.add((Component)plotter.getPlotter(), "Center");
        final ListeningJComboBox combo = new ListeningJComboBox(settings, "_plot_column_" + PlotterAdapter.transformParameterName(plotter.getPlotName()), distributionModel.getAttributeNames());
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.insets = new Insets(4, 4, 4, 4);
        c.gridwidth = 0;
        JPanel boxPanel = new JPanel(layout);
        JLabel label = new JLabel("Attribute:");
        layout.setConstraints(label, c);
        boxPanel.add(label);
        layout.setConstraints(combo, c);
        boxPanel.add(combo);
        final JCheckBox rotateLabels = new JCheckBox("Rotate Labels", false);
        layout.setConstraints(rotateLabels, c);
        boxPanel.add(rotateLabels);
        c.weighty = 1.0;
        JPanel fillPanel = new JPanel();
        layout.setConstraints(fillPanel, c);
        boxPanel.add(fillPanel);
        graphPanel.add((Component)boxPanel, "West");
        combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                settings.setParameterAsString("_plot_column", combo.getSelectedItem().toString());
            }
        });
        rotateLabels.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                settings.setParameterAsBoolean(DistributionModelPlotRenderer.PARAMETER_ROTATE_LABELS, rotateLabels.isSelected());
            }
        });
        combo.setSelectedIndex(0);
        return graphPanel;
    }

    @Override
    public List<ParameterType> getParameterTypes(InputPort inputPort) {
        List<ParameterType> types = super.getParameterTypes(inputPort);
        if (inputPort != null) {
            types.add(new ParameterTypeAttribute(PARAMETER_ATTRIBUTE_NAME, "Indicates for which attribute the distribution should be plotted.", inputPort, false));
        } else {
            types.add(new ParameterTypeString(PARAMETER_ATTRIBUTE_NAME, "Indicates for which attribute the distribution should be plotted.", false));
        }
        types.add(new ParameterTypeTupel(PARAMETER_RANGE, "Defines the range of the corresponding axis.", new ParameterTypeDouble(PARAMETER_RANGE_MIN, "Defines the lower bound of the axis.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY), new ParameterTypeDouble(PARAMETER_RANGE_MAX, "Defines the upper bound of the axis.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY)));
        types.add(new ParameterTypeBoolean(PARAMETER_ROTATE_LABELS, "Indicates if the labels should be rotated.", false));
        return types;
    }
}

