/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.renderer.math;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.gui.renderer.AbstractDataTableTableRenderer;
import com.rapidminer.gui.tools.CellColorProvider;
import com.rapidminer.gui.tools.CellColorProviderScaled;
import com.rapidminer.gui.tools.ExtendedJTable;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.visualization.dependencies.NumericalMatrix;

public class NumericalMatrixTableRenderer
extends AbstractDataTableTableRenderer {
    @Override
    public DataTable getDataTable(Object renderable, IOContainer ioContainer, boolean isRendering) {
        NumericalMatrix matrix = (NumericalMatrix)renderable;
        return matrix.createMatrixDataTable();
    }

    @Override
    protected CellColorProvider getCellColorProvider(ExtendedJTable table, Object renderable) {
        NumericalMatrix matrix = (NumericalMatrix)renderable;
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (int x = 0; x < matrix.getNumberOfRows(); ++x) {
            for (int y = 0; y < matrix.getNumberOfColumns(); ++y) {
                double value = Math.abs(matrix.getValue(x, y));
                if (Double.isNaN(value)) continue;
                min = Math.min(min, value);
                max = Math.max(max, value);
            }
        }
        return new CellColorProviderScaled(table, true, min, max);
    }

    @Override
    public boolean isAutoresize() {
        return false;
    }
}

