/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.renderer.data;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableExampleSetAdapter;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.gui.plotter.Plotter;
import com.rapidminer.gui.plotter.PlotterConfigurationModel;
import com.rapidminer.gui.renderer.AbstractDataTablePlotterRenderer;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.MissingIOObjectException;
import java.util.LinkedHashMap;

public class ExampleSetPlotRenderer
extends AbstractDataTablePlotterRenderer {
    @Override
    public LinkedHashMap<String, Class<? extends Plotter>> getPlotterSelection() {
        return PlotterConfigurationModel.DATA_SET_PLOTTER_SELECTION;
    }

    @Override
    public DataTable getDataTable(Object renderable, IOContainer container) {
        ExampleSet exampleSet = (ExampleSet)renderable;
        AttributeWeights weights = null;
        if (container != null) {
            try {
                weights = container.get(AttributeWeights.class);
                for (Attribute attribute : exampleSet.getAttributes()) {
                    double weight = weights.getWeight(attribute.getName());
                    if (!Double.isNaN(weight)) continue;
                    weights = null;
                    break;
                }
            }
            catch (MissingIOObjectException e) {
                // empty catch block
            }
        }
        return new DataTableExampleSetAdapter(exampleSet, weights);
    }
}

