/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.renderer.data;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.gui.plotter.PlotterAdapter;
import com.rapidminer.gui.renderer.AbstractTableModelTableRenderer;
import com.rapidminer.gui.viewer.MetaDataViewer;
import com.rapidminer.gui.viewer.MetaDataViewerTableModel;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.tools.AttributeSubsetSelector;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.UndefinedParameterError;
import java.awt.Component;
import java.util.LinkedList;
import java.util.List;
import javax.swing.table.TableModel;

public class ExampleSetMetaDataRenderer
extends AbstractTableModelTableRenderer {
    private AttributeSubsetSelector subsetSelector = null;

    @Override
    public String getName() {
        return "Meta Data View";
    }

    @Override
    public Component getVisualizationComponent(Object renderable, IOContainer ioContainer) {
        ExampleSet exampleSet = (ExampleSet)renderable;
        return new MetaDataViewer(exampleSet, true);
    }

    @Override
    public TableModel getTableModel(Object renderable, IOContainer ioContainer, boolean isReporting) {
        ExampleSet exampleSet = (ExampleSet)renderable;
        if (isReporting && this.subsetSelector != null) {
            try {
                exampleSet = this.subsetSelector.getSubset(exampleSet, false);
            }
            catch (UndefinedParameterError e) {
            }
            catch (UserError e) {
                // empty catch block
            }
        }
        MetaDataViewerTableModel model = new MetaDataViewerTableModel(exampleSet);
        for (int i = 0; i < MetaDataViewerTableModel.COLUMN_NAMES.length; ++i) {
            model.setShowColumn(i, this.getParameterAsBoolean("show_" + PlotterAdapter.transformParameterName(MetaDataViewerTableModel.COLUMN_NAMES[i])));
        }
        return model;
    }

    @Override
    public List<ParameterType> getParameterTypes(InputPort inputPort) {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        this.subsetSelector = new AttributeSubsetSelector(this, inputPort);
        types.addAll(this.subsetSelector.getParameterTypes());
        for (int i = 0; i < MetaDataViewerTableModel.COLUMN_NAMES.length; ++i) {
            ParameterTypeBoolean type = new ParameterTypeBoolean("show_" + PlotterAdapter.transformParameterName(MetaDataViewerTableModel.COLUMN_NAMES[i]), MetaDataViewerTableModel.COLUMN_TOOL_TIPS[i], true, false);
            types.add(type);
        }
        return types;
    }
}

