/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.renderer.data;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableExampleSetAdapter;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.gui.renderer.AbstractDataTableTableRenderer;
import com.rapidminer.gui.viewer.DataViewer;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.MissingIOObjectException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.tools.AttributeSubsetSelector;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.UndefinedParameterError;
import java.awt.Component;
import java.util.LinkedList;
import java.util.List;

public class ExampleSetDataRenderer
extends AbstractDataTableTableRenderer {
    public static final String RENDERER_NAME = "Data View";
    private AttributeSubsetSelector subsetSelector = null;

    @Override
    public String getName() {
        return RENDERER_NAME;
    }

    @Override
    public Component getVisualizationComponent(Object renderable, IOContainer ioContainer) {
        ExampleSet exampleSet = (ExampleSet)renderable;
        return new DataViewer(exampleSet, true);
    }

    @Override
    public DataTable getDataTable(Object renderable, IOContainer container, boolean isRendering) {
        ExampleSet exampleSet = (ExampleSet)renderable;
        if (isRendering) {
            try {
                exampleSet = this.subsetSelector.getSubset(exampleSet, false);
            }
            catch (UndefinedParameterError e1) {
            }
            catch (UserError e1) {
                // empty catch block
            }
        }
        AttributeWeights weights = null;
        if (container != null) {
            try {
                weights = container.get(AttributeWeights.class);
                for (Attribute attribute : exampleSet.getAttributes()) {
                    double weight = weights.getWeight(attribute.getName());
                    if (!Double.isNaN(weight)) continue;
                    weights = null;
                    break;
                }
            }
            catch (MissingIOObjectException e) {
                // empty catch block
            }
        }
        return new DataTableExampleSetAdapter(exampleSet, weights);
    }

    @Override
    public List<ParameterType> getParameterTypes(InputPort inputPort) {
        ExampleSetMetaData emd;
        MetaData metaData;
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        this.subsetSelector = new AttributeSubsetSelector(this, inputPort);
        types.addAll(this.subsetSelector.getParameterTypes());
        int max_row = Integer.MAX_VALUE;
        if (inputPort != null && (metaData = inputPort.getMetaData()) != null && metaData instanceof ExampleSetMetaData && (emd = (ExampleSetMetaData)metaData).getNumberOfExamples().isKnown()) {
            max_row = (Integer)emd.getNumberOfExamples().getNumber();
        }
        types.add(new ParameterTypeInt("min_row", "Indicates the first row number which should be rendered.", 1, Integer.MAX_VALUE, 1, false));
        types.add(new ParameterTypeInt("max_row", "Indicates the last row number which should be rendered.", 1, Integer.MAX_VALUE, max_row, false));
        return types;
    }
}

