/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.renderer.cluster;

import com.rapidminer.gui.renderer.AbstractRenderer;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.viewer.ClusterTreeVisualization;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.clustering.CentroidClusterModel;
import com.rapidminer.operator.clustering.ClusterModel;
import com.rapidminer.operator.clustering.HierarchicalClusterModel;
import com.rapidminer.report.Reportable;
import java.awt.Component;
import javax.swing.JLabel;

public class ClusterModelFolderRenderer
extends AbstractRenderer {
    @Override
    public String getName() {
        return "Folder View";
    }

    @Override
    public Component getVisualizationComponent(Object renderable, IOContainer ioContainer) {
        if (renderable instanceof HierarchicalClusterModel) {
            return new ExtendedJScrollPane(new ClusterTreeVisualization((HierarchicalClusterModel)renderable));
        }
        if (renderable instanceof ClusterModel) {
            return new ExtendedJScrollPane(new ClusterTreeVisualization((ClusterModel)renderable));
        }
        return new JLabel("no folder visualization supported for this kind of cluster model " + renderable.getClass());
    }

    @Override
    public Reportable createReportable(Object renderable, IOContainer ioContainer, int width, int height) {
        ClusterTreeVisualization plotter = null;
        if (renderable instanceof HierarchicalClusterModel) {
            plotter = new ClusterTreeVisualization((HierarchicalClusterModel)renderable);
        } else if (renderable instanceof CentroidClusterModel) {
            plotter = new ClusterTreeVisualization((CentroidClusterModel)renderable);
        }
        if (plotter != null) {
            plotter.setSize(width, height);
        }
        return plotter;
    }
}

