/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.renderer.cluster;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.SimpleDataTable;
import com.rapidminer.datatable.SimpleDataTableRow;
import com.rapidminer.gui.plotter.Plotter;
import com.rapidminer.gui.plotter.PlotterAdapter;
import com.rapidminer.gui.plotter.PlotterConfigurationModel;
import com.rapidminer.gui.renderer.AbstractRenderer;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.clustering.CentroidClusterModel;
import com.rapidminer.report.Reportable;
import java.awt.Component;

public class ClusterModelCentroidPlotRenderer
extends AbstractRenderer {
    @Override
    public String getName() {
        return "Centroid Plot View";
    }

    private Plotter createCentroidPlotter(CentroidClusterModel cm, int width, int height) {
        String[] dimensionNames = cm.getAttributeNames();
        String[] columnNames = new String[dimensionNames.length + 1];
        System.arraycopy(dimensionNames, 0, columnNames, 0, dimensionNames.length);
        columnNames[columnNames.length - 1] = "Cluster";
        SimpleDataTable dataTable = new SimpleDataTable("Centroid Positions", columnNames);
        for (int i = 0; i < cm.getNumberOfClusters(); ++i) {
            double[] centroidValues = cm.getCentroidCoordinates(i);
            String clusterName = cm.getCluster(i).getClusterId() + "";
            double[] values = new double[centroidValues.length + 1];
            System.arraycopy(centroidValues, 0, values, 0, centroidValues.length);
            values[values.length - 1] = dataTable.mapString(values.length - 1, clusterName);
            dataTable.add(new SimpleDataTableRow(values));
        }
        PlotterConfigurationModel settings = new PlotterConfigurationModel("Parallel", (DataTable)dataTable);
        Plotter plotter = settings.getPlotter();
        settings.setParameterAsString("_plot_columns_" + PlotterAdapter.transformParameterName(plotter.getPlotName()), columnNames[columnNames.length - 1]);
        settings.setParameterAsBoolean("local_normalization", false);
        plotter.getPlotter().setSize(width, height);
        return plotter;
    }

    @Override
    public Component getVisualizationComponent(Object renderable, IOContainer ioContainer) {
        CentroidClusterModel cm = (CentroidClusterModel)renderable;
        return this.createCentroidPlotter(cm, 800, 600).getPlotter();
    }

    @Override
    public Reportable createReportable(Object renderable, IOContainer ioContainer, int width, int height) {
        CentroidClusterModel cm = (CentroidClusterModel)renderable;
        return this.createCentroidPlotter(cm, width, height);
    }
}

