/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.renderer.associations;

import com.rapidminer.gui.renderer.AbstractTableModelTableRenderer;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.learner.associations.gsp.GSPSet;
import com.rapidminer.operator.learner.associations.gsp.Sequence;
import com.rapidminer.operator.learner.associations.gsp.Transaction;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class GSPRenderer
extends AbstractTableModelTableRenderer {
    @Override
    public TableModel getTableModel(Object renderable, IOContainer ioContainer, boolean isReporting) {
        final GSPSet set = (GSPSet)renderable;
        final double[] supports = set.getSupportArray();
        final Sequence[] sequences = set.getSequenceArray();
        return new AbstractTableModel(){
            private static final long serialVersionUID = 7884607018618465026L;

            @Override
            public int getColumnCount() {
                return set.getMaxTransactions() + 3;
            }

            @Override
            public int getRowCount() {
                return set.getNumberOfSequences();
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                if (columnIndex == 0) {
                    return supports[rowIndex];
                }
                if (columnIndex == 1) {
                    return sequences[rowIndex].size();
                }
                if (columnIndex == 2) {
                    return sequences[rowIndex].getNumberOfItems();
                }
                Sequence sequence = sequences[rowIndex];
                if (sequence.size() > columnIndex - 3) {
                    return ((Transaction)sequence.get(columnIndex - 3)).toString();
                }
                return "";
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                if (columnIndex == 0) {
                    return Double.class;
                }
                if (columnIndex == 0) {
                    return Integer.class;
                }
                return String.class;
            }

            @Override
            public String getColumnName(int columnIndex) {
                if (columnIndex == 0) {
                    return "Support";
                }
                if (columnIndex == 1) {
                    return "Transactions";
                }
                if (columnIndex == 2) {
                    return "Items";
                }
                return "Transaction " + (columnIndex - 3);
            }
        };
    }

    @Override
    public boolean isAutoresize() {
        return true;
    }
}

