/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.renderer;

import com.rapidminer.gui.renderer.Renderer;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.IOObject;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Tools;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RendererService {
    private static final Icon ICON_DEFAULT = SwingTools.createIcon("16/data.png");
    private static Set<String> objectNames = new TreeSet<String>();
    private static Map<String, List<Renderer>> objectRenderers = new HashMap<String, List<Renderer>>();
    private static Map<String, Map<String, Class<? extends Renderer>>> rendererNameToRendererClasses = new HashMap<String, Map<String, Class<? extends Renderer>>>();
    private static Map<String, Class<? extends IOObject>> objectClasses = new HashMap<String, Class<? extends IOObject>>();
    private static Set<String> reportableMap = new HashSet<String>();
    private static Map<Class<?>, String> class2NameMap = new HashMap();
    private static Map<Class<? extends IOObject>, Icon> class2IconMap = new HashMap<Class<? extends IOObject>, Icon>();

    public static void init() {
        URL url = Tools.getResource("ioobjects.xml");
        RendererService.init(url);
        RendererService.init("ioobjects.xml", url, RendererService.class.getClassLoader());
    }

    public static void init(URL ioObjectsURL) {
        RendererService.init(ioObjectsURL.getFile(), ioObjectsURL, RendererService.class.getClassLoader());
    }

    public static void init(String name, InputStream in) {
        RendererService.init(name, in, RendererService.class.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(String name, URL ioObjectsURL, ClassLoader classLoader) {
        InputStream in = null;
        try {
            if (ioObjectsURL != null) {
                in = ioObjectsURL.openStream();
                RendererService.init(name, in, classLoader);
            }
        }
        catch (IOException e) {
            LogService.getRoot().log(Level.WARNING, "Cannot initialize io object description of plugin" + name + ": " + "Cannot parse document: " + e, e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(String rendererFileName, InputStream in, ClassLoader classLoader) {
        LogService.getRoot().config("Loading renderers from '" + rendererFileName + "'.");
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in);
            Element ioObjectsElement = document.getDocumentElement();
            if (ioObjectsElement.getTagName().equals("ioobjects")) {
                NodeList ioObjectNodes = ioObjectsElement.getElementsByTagName("ioobject");
                for (int i = 0; i < ioObjectNodes.getLength(); ++i) {
                    Node ioObjectNode = ioObjectNodes.item(i);
                    if (!(ioObjectNode instanceof Element)) continue;
                    Element ioObjectElement = (Element)ioObjectNode;
                    String name = ioObjectElement.getAttribute("name");
                    String className = ioObjectElement.getAttribute("class");
                    String reportableString = "true";
                    if (ioObjectElement.hasAttribute("reportable")) {
                        reportableString = ioObjectElement.getAttribute("reportable");
                    }
                    boolean reportable = Tools.booleanValue(reportableString, true);
                    String icon = null;
                    if (ioObjectElement.hasAttribute("icon")) {
                        icon = ioObjectElement.getAttribute("icon");
                    }
                    NodeList rendererNodes = ioObjectElement.getElementsByTagName("renderer");
                    LinkedList<String> renderers = new LinkedList<String>();
                    for (int k = 0; k < rendererNodes.getLength(); ++k) {
                        Node rendererNode = rendererNodes.item(k);
                        if (!(rendererNode instanceof Element)) continue;
                        Element rendererElement = (Element)rendererNode;
                        String rendererName = rendererElement.getTextContent();
                        renderers.add(rendererName);
                    }
                    RendererService.registerRenderers(name, className, reportable, icon, renderers, classLoader);
                }
            } else {
                LogService.getRoot().warning("Cannot initialize io object description: Outermost tag of a ioobjects.xml definition must be <ioobjects>!");
            }
        }
        catch (IOException e) {
            LogService.getRoot().log(Level.WARNING, "Cannot initialize io object description: Cannot parse document: " + e, e);
        }
        catch (ParserConfigurationException e) {
            LogService.getRoot().log(Level.WARNING, "Cannot initialize io object description: " + e, e);
        }
        catch (SAXException e) {
            LogService.getRoot().log(Level.WARNING, "Cannot initialize io object description: Cannot parse document: " + e, e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Deprecated
    public static void registerRenderers(String reportableNames, String className, boolean reportable, List<String> rendererClassNames, ClassLoader classLoader) {
        RendererService.registerRenderers(reportableNames, className, reportable, null, rendererClassNames, classLoader);
    }

    public static void registerRenderers(String reportableNames, String className, boolean reportable, String iconName, List<String> rendererClassNames, ClassLoader classLoader) {
        objectNames.add(reportableNames);
        try {
            ImageIcon icon;
            Class<?> clazz = Class.forName(className, true, classLoader);
            LinkedList<Renderer> renderers = new LinkedList<Renderer>();
            HashMap rendererClassMap = new HashMap();
            for (String rendererClassName : rendererClassNames) {
                Class<?> rendererClass;
                try {
                    rendererClass = Class.forName(rendererClassName, true, classLoader);
                }
                catch (Exception e) {
                    rendererClass = Class.forName(rendererClassName);
                }
                Renderer renderer = (Renderer)rendererClass.newInstance();
                renderers.add(renderer);
                rendererClassMap.put(renderer.getName(), rendererClass);
            }
            rendererNameToRendererClasses.put(reportableNames, rendererClassMap);
            objectRenderers.put(reportableNames, renderers);
            objectClasses.put(reportableNames, clazz);
            class2NameMap.put(clazz, reportableNames);
            if (reportable) {
                reportableMap.add(reportableNames);
            }
            if (iconName != null && !iconName.isEmpty() && (icon = SwingTools.createIcon("16/" + iconName)) != null) {
                class2IconMap.put(clazz, icon);
            }
        }
        catch (Throwable e) {
            LogService.getRoot().log(Level.WARNING, "Cannot register renderer: " + e, e);
        }
    }

    public static Set<String> getAllRenderableObjectNames() {
        return objectNames;
    }

    public static Set<String> getAllReportableObjectNames() {
        TreeSet<String> result = new TreeSet<String>();
        for (String name : objectNames) {
            if (!reportableMap.contains(name)) continue;
            result.add(name);
        }
        return result;
    }

    public static String getName(Class<?> clazz) {
        String result = class2NameMap.get(clazz);
        if (result == null) {
            for (Class<?> renderable : class2NameMap.keySet()) {
                if (!renderable.isAssignableFrom(clazz)) continue;
                return class2NameMap.get(renderable);
            }
        }
        return result;
    }

    public static Class<? extends IOObject> getClass(String name) {
        return objectClasses.get(name);
    }

    public static List<Renderer> getRenderers(String reportableName) {
        List<Renderer> renderers = objectRenderers.get(reportableName);
        if (renderers != null) {
            return renderers;
        }
        return new LinkedList<Renderer>();
    }

    public static List<Renderer> getRenderers(IOObject ioo) {
        String reportableName = RendererService.getName(ioo.getClass());
        return RendererService.getRenderers(reportableName);
    }

    public static Renderer getRenderer(String reportableName, String rendererName) {
        List<Renderer> renderers = RendererService.getRenderers(reportableName);
        for (Renderer renderer : renderers) {
            if (!renderer.getName().equals(rendererName)) continue;
            return renderer;
        }
        return null;
    }

    public static Icon getIcon(Class<? extends IOObject> objectClass) {
        if (objectClass == null) {
            return ICON_DEFAULT;
        }
        Icon icon = class2IconMap.get(objectClass);
        if (icon == null) {
            for (Map.Entry<Class<? extends IOObject>, Icon> renderableClassEntry : class2IconMap.entrySet()) {
                if (!renderableClassEntry.getKey().isAssignableFrom(objectClass)) continue;
                class2IconMap.put(objectClass, renderableClassEntry.getValue());
                return renderableClassEntry.getValue();
            }
            return ICON_DEFAULT;
        }
        return icon;
    }

    public static Renderer createRenderer(IOObject ioobject, String rendererName) {
        String reportableName = RendererService.getName(ioobject.getClass());
        Map<String, Class<? extends Renderer>> rendererClassMap = rendererNameToRendererClasses.get(reportableName);
        if (rendererClassMap == null) {
            throw new IllegalArgumentException("Illegal reportable name: " + rendererName);
        }
        Class<? extends Renderer> rendererClass = rendererClassMap.get(rendererName);
        if (rendererClass == null) {
            throw new IllegalArgumentException("Illegal renderer name: " + rendererName);
        }
        try {
            return rendererClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create renderer: " + e, e);
        }
    }
}

