/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.renderer;

import com.rapidminer.gui.renderer.DefaultReadable;
import com.rapidminer.gui.renderer.NonGraphicalRenderer;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.ResultObject;
import com.rapidminer.report.Reportable;
import com.rapidminer.tools.Tools;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JLabel;

public class DefaultTextRenderer
extends NonGraphicalRenderer {
    @Override
    public String getName() {
        return "Text View";
    }

    @Override
    public Component getVisualizationComponent(Object renderable, IOContainer ioContainer) {
        JEditorPane resultText = new JEditorPane();
        resultText.setContentType("text/html");
        resultText.setBorder(BorderFactory.createEmptyBorder(11, 11, 11, 11));
        resultText.setEditable(false);
        resultText.setBackground(new JLabel().getBackground());
        if (renderable instanceof ResultObject) {
            ResultObject result = (ResultObject)renderable;
            String str = this.toHTML(result.toResultString());
            resultText.setText("<html><h1>" + result.getName() + "</h1><pre>" + str + "</pre></html>");
        } else {
            String str = this.toHTML(renderable.toString());
            resultText.setText("<html><h1>" + renderable.getClass().getSimpleName() + "</h1><pre>" + str + "</pre></html>");
        }
        return new ExtendedJScrollPane(resultText);
    }

    private String toHTML(String string) {
        String str = string;
        str = str.replaceAll(">", "&gt;");
        str = str.replaceAll("<", "&lt;");
        str = str.replaceAll(Tools.getLineSeparator(), "<br>");
        return str;
    }

    @Override
    public Reportable createReportable(Object renderable, IOContainer ioContainer) {
        return new DefaultReadable(renderable.toString());
    }
}

