/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.renderer;

import com.rapidminer.gui.renderer.DefaultReadable;
import com.rapidminer.gui.renderer.NonGraphicalRenderer;
import com.rapidminer.gui.viewer.collection.CollectionViewer;
import com.rapidminer.operator.GroupedModel;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObjectCollection;
import com.rapidminer.report.Reportable;
import java.awt.Component;

public class CollectionRenderer
extends NonGraphicalRenderer {
    @Override
    public String getName() {
        return "Collection";
    }

    @Override
    public Component getVisualizationComponent(Object renderable, IOContainer ioContainer) {
        if (renderable instanceof GroupedModel) {
            GroupedModel cm = (GroupedModel)renderable;
            return new CollectionViewer(cm, ioContainer);
        }
        if (renderable instanceof IOObjectCollection) {
            return new CollectionViewer((IOObjectCollection)renderable, ioContainer);
        }
        throw new IllegalArgumentException("Renderable must be GroupedModel or IOObjectCollection, but is " + renderable.getClass());
    }

    @Override
    public Reportable createReportable(Object renderable, IOContainer ioContainer) {
        return new DefaultReadable(renderable.toString());
    }
}

