/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.renderer;

import com.rapidminer.gui.renderer.AbstractRenderer;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.Annotations;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.report.Reportable;
import com.rapidminer.report.Tableable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class AnnotationsRenderer
extends AbstractRenderer {
    @Override
    public String getName() {
        return "Annotations";
    }

    @Override
    public Reportable createReportable(Object renderable, IOContainer ioContainer, int desiredWidth, int desiredHeight) {
        final Annotations annotations = ((IOObject)renderable).getAnnotations();
        return new Tableable(){

            @Override
            public void finishReporting() {
            }

            @Override
            public String getCell(int row, int column) {
                switch (column) {
                    case 0: {
                        return annotations.getKeys().get(row);
                    }
                    case 1: {
                        return annotations.getAnnotation(annotations.getKeys().get(row));
                    }
                }
                return null;
            }

            @Override
            public String getColumnName(int index) {
                switch (index) {
                    case 0: {
                        return "Key";
                    }
                    case 1: {
                        return "Annotation";
                    }
                }
                return null;
            }

            @Override
            public int getColumnNumber() {
                return 2;
            }

            @Override
            public int getRowNumber() {
                return annotations.size();
            }

            @Override
            public boolean isFirstColumnHeader() {
                return false;
            }

            @Override
            public boolean isFirstLineHeader() {
                return true;
            }

            @Override
            public void prepareReporting() {
            }
        };
    }

    @Override
    public Component getVisualizationComponent(Object renderable, IOContainer ioContainer) {
        if (!(renderable instanceof IOObject)) {
            throw new RuntimeException("Can only display IOObjects");
        }
        IOObject ioobject = (IOObject)renderable;
        JPanel component = new JPanel(new BorderLayout());
        final AnnotationsTableModel model = new AnnotationsTableModel(ioobject);
        final JTable table = new JTable(model);
        table.setRowHeight(28);
        ExtendedJScrollPane scrollPane = new ExtendedJScrollPane(table);
        scrollPane.setBorder(null);
        component.add((Component)scrollPane, "Center");
        JPanel buttons = new JPanel(new FlowLayout(0));
        buttons.add(new JButton(new ResourceAction("add_annotation", new Object[0]){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                String key = (String)SwingTools.showInputDialog("select_annotation", Annotations.ALL_KEYS_IOOBJECT, (Object)Annotations.ALL_KEYS_IOOBJECT[0], new Object[0]);
                if (key != null) {
                    model.addRow(key);
                }
            }
        }));
        buttons.add(new JButton(new ResourceAction("delete_annotation", new Object[0]){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                model.deleteRow(table.getSelectedRow());
            }
        }));
        component.add((Component)buttons, "South");
        return component;
    }

    private static final class AnnotationsTableModel
    extends AbstractTableModel {
        private final IOObject ioobject;
        private static final long serialVersionUID = 1L;

        private AnnotationsTableModel(IOObject ioobject) {
            this.ioobject = ioobject;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "Key";
                }
                case 1: {
                    return "Annotation";
                }
            }
            return "";
        }

        @Override
        public int getRowCount() {
            return this.ioobject.getAnnotations().size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Annotations annotations = this.ioobject.getAnnotations();
            switch (columnIndex) {
                case 0: {
                    return annotations.getKeys().get(rowIndex);
                }
                case 1: {
                    return annotations.getAnnotation(annotations.getKeys().get(rowIndex));
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            Annotations annotations = this.ioobject.getAnnotations();
            switch (columnIndex) {
                case 0: {
                    throw new RuntimeException("Key collumn is immutable.");
                }
                case 1: {
                    annotations.setAnnotation(annotations.getKeys().get(rowIndex), aValue.toString());
                    break;
                }
            }
        }

        private void addRow(String key) {
            this.ioobject.getAnnotations().setAnnotation(key, "");
            int newSize = this.ioobject.getAnnotations().size();
            this.fireTableRowsInserted(newSize, newSize);
        }

        public void deleteRow(int row) {
            if (row >= 0) {
                this.ioobject.getAnnotations().removeAnnotation(this.ioobject.getAnnotations().getKeys().get(row));
                this.fireTableRowsDeleted(row, row);
            }
        }
    }
}

