/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.renderer;

import com.rapidminer.gui.renderer.NonGraphicalRenderer;
import com.rapidminer.gui.renderer.Renderer;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ExtendedJTable;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.report.Reportable;
import com.rapidminer.report.Tableable;
import com.rapidminer.tools.Tools;
import java.awt.Component;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.table.TableModel;

public abstract class AbstractTableModelTableRenderer
extends NonGraphicalRenderer {
    public static final String RENDERER_NAME = "Table View";
    public static final String PARAMETER_MIN_ROW = "min_row";
    public static final String PARAMETER_MAX_ROW = "max_row";
    public static final String PARAMETER_MIN_COLUMN = "min_column";
    public static final String PARAMETER_MAX_COLUMN = "max_column";
    public static final String PARAMETER_SORT_COLUMN = "sort_column";
    public static final String PARAMETER_SORT_DECREASING = "sort_decreasing";

    @Override
    public String getName() {
        return RENDERER_NAME;
    }

    public abstract TableModel getTableModel(Object var1, IOContainer var2, boolean var3);

    public boolean isSortable() {
        return true;
    }

    public boolean isColumnMovable() {
        return true;
    }

    public boolean isAutoresize() {
        return false;
    }

    @Override
    public Component getVisualizationComponent(Object renderable, IOContainer ioContainer) {
        TableModel tableModel = this.getTableModel(renderable, ioContainer, false);
        if (tableModel != null) {
            return new ExtendedJScrollPane(new ExtendedJTable(this.getTableModel(renderable, ioContainer, false), this.isSortable(), this.isColumnMovable(), this.isAutoresize()));
        }
        return new JLabel("No visualization possible for table.");
    }

    @Override
    public Reportable createReportable(Object renderable, IOContainer ioContainer) {
        TableModel tableModel = this.getTableModel(renderable, ioContainer, true);
        if (tableModel != null) {
            return new DefaultTableable(tableModel, this);
        }
        return null;
    }

    @Override
    public List<ParameterType> getParameterTypes(InputPort inputPort) {
        MetaData metaData;
        List<ParameterType> types = super.getParameterTypes(inputPort);
        int max_row = Integer.MAX_VALUE;
        int max_column = Integer.MAX_VALUE;
        if (inputPort != null && (metaData = inputPort.getMetaData()) != null && metaData instanceof ExampleSetMetaData) {
            ExampleSetMetaData emd = (ExampleSetMetaData)metaData;
            if (emd.getNumberOfExamples().isKnown()) {
                max_row = (Integer)emd.getNumberOfExamples().getNumber();
            }
            max_column = emd.getAllAttributes().size();
        }
        types.add(new ParameterTypeInt(PARAMETER_MIN_ROW, "Indicates the first row number which should be rendered.", 1, Integer.MAX_VALUE, 1));
        types.add(new ParameterTypeInt(PARAMETER_MAX_ROW, "Indicates the last row number which should be rendered.", 1, Integer.MAX_VALUE, max_row));
        types.add(new ParameterTypeInt(PARAMETER_MIN_COLUMN, "Indicates the first column number which should be rendered.", 1, Integer.MAX_VALUE, 1));
        types.add(new ParameterTypeInt(PARAMETER_MAX_COLUMN, "Indicates the last column number which should be rendered.", 1, Integer.MAX_VALUE, max_column));
        types.add(new ParameterTypeInt(PARAMETER_SORT_COLUMN, "Specifies the column to use for sorting.", 1, Integer.MAX_VALUE, max_column));
        types.add(new ParameterTypeBoolean(PARAMETER_SORT_DECREASING, "Use decrease sorting instead.", false));
        return types;
    }

    public static class DefaultTableable
    implements Tableable {
        private TableModel model;
        private int minRow = 0;
        private int maxRow = Integer.MAX_VALUE;
        private int minColumn = 0;
        private int maxColumn = Integer.MAX_VALUE;
        private boolean enableSorting = false;
        private int sortColumn = 0;
        private Integer[] sortIndices = null;

        public DefaultTableable(final TableModel model, Renderer renderer) {
            this.model = model;
            try {
                Object minRowO = renderer.getParameter(AbstractTableModelTableRenderer.PARAMETER_MIN_ROW);
                this.minRow = minRowO != null ? Integer.valueOf(minRowO.toString()) - 1 : 0;
            }
            catch (UndefinedParameterError e) {
                this.minRow = 0;
            }
            try {
                Object maxRowO = renderer.getParameter(AbstractTableModelTableRenderer.PARAMETER_MAX_ROW);
                this.maxRow = maxRowO != null ? Integer.valueOf(maxRowO.toString()) - 1 : Integer.MAX_VALUE;
            }
            catch (UndefinedParameterError e) {
                this.maxRow = Integer.MAX_VALUE;
            }
            try {
                Object minColO = renderer.getParameter(AbstractTableModelTableRenderer.PARAMETER_MIN_COLUMN);
                this.minColumn = minColO != null ? Integer.valueOf(minColO.toString()) - 1 : 0;
            }
            catch (UndefinedParameterError e) {
                this.minColumn = 0;
            }
            try {
                Object maxColO = renderer.getParameter(AbstractTableModelTableRenderer.PARAMETER_MAX_COLUMN);
                this.maxColumn = maxColO != null ? Integer.valueOf(maxColO.toString()) - 1 : Integer.MAX_VALUE;
            }
            catch (UndefinedParameterError e) {
                this.maxColumn = Integer.MAX_VALUE;
            }
            try {
                Object sortColumnObj = renderer.getParameter(AbstractTableModelTableRenderer.PARAMETER_SORT_COLUMN);
                if (sortColumnObj != null) {
                    this.sortColumn = Integer.valueOf(sortColumnObj.toString()) - 1;
                    if (this.sortColumn < model.getColumnCount()) {
                        Object decreasingOrderO = renderer.getParameter(AbstractTableModelTableRenderer.PARAMETER_SORT_DECREASING);
                        final boolean sortDecreasing = decreasingOrderO == null ? false : Boolean.valueOf(decreasingOrderO.toString());
                        this.enableSorting = true;
                        this.sortIndices = new Integer[this.getRowNumber()];
                        for (int i = 0; i < this.sortIndices.length; ++i) {
                            this.sortIndices[i] = i;
                        }
                        Arrays.sort(this.sortIndices, new Comparator<Integer>(){

                            @Override
                            public int compare(Integer o1, Integer o2) {
                                Comparable c2 = (Comparable)model.getValueAt(DefaultTableable.this.minRow + o1, DefaultTableable.this.sortColumn);
                                Comparable c1 = (Comparable)model.getValueAt(DefaultTableable.this.minRow + o2, DefaultTableable.this.sortColumn);
                                if (c1 == null & c2 == null) {
                                    return 0;
                                }
                                if (c1 == null && c2 != null) {
                                    return -1;
                                }
                                if (c1 != null && c2 == null) {
                                    return 1;
                                }
                                if (sortDecreasing) {
                                    return c1.compareTo(c2);
                                }
                                return c2.compareTo(c1);
                            }
                        });
                    }
                } else {
                    this.enableSorting = false;
                }
            }
            catch (UndefinedParameterError e) {
                this.maxColumn = Integer.MAX_VALUE;
            }
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.model.getColumnName(columnIndex + this.minColumn);
        }

        @Override
        public String getCell(int row, int column) {
            String value;
            Object objValue = this.enableSorting ? this.model.getValueAt(this.sortIndices[row], column + this.minColumn) : this.model.getValueAt(row + this.minRow, column + this.minColumn);
            String string = value = objValue == null ? "" : objValue.toString();
            if (Number.class.isAssignableFrom(this.model.getColumnClass(column))) {
                return Tools.formatIntegerIfPossible(Double.valueOf(value));
            }
            return value;
        }

        @Override
        public int getColumnNumber() {
            int maxC = this.maxColumn;
            if (this.maxColumn >= this.model.getColumnCount()) {
                maxC = this.model.getColumnCount() - 1;
            }
            return maxC - this.minColumn + 1;
        }

        @Override
        public int getRowNumber() {
            int maxR = this.maxRow;
            if (this.maxRow >= this.model.getRowCount()) {
                maxR = this.model.getRowCount() - 1;
            }
            return maxR - this.minRow + 1;
        }

        @Override
        public void prepareReporting() {
        }

        @Override
        public void finishReporting() {
        }

        @Override
        public boolean isFirstLineHeader() {
            return false;
        }

        @Override
        public boolean isFirstColumnHeader() {
            return false;
        }
    }
}

