/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.renderer;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.gui.renderer.NonGraphicalRenderer;
import com.rapidminer.gui.renderer.Renderer;
import com.rapidminer.gui.tools.CellColorProvider;
import com.rapidminer.gui.tools.CellColorProviderAlternating;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ExtendedJTable;
import com.rapidminer.gui.viewer.DataTableViewerTable;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.report.Reportable;
import com.rapidminer.report.Tableable;
import java.awt.Component;
import java.util.List;
import javax.swing.JLabel;

public abstract class AbstractDataTableTableRenderer
extends NonGraphicalRenderer {
    public static final String RENDERER_NAME = "Table View";
    public static final String PARAMETER_MIN_ROW = "min_row";
    public static final String PARAMETER_MAX_ROW = "max_row";
    public static final String PARAMETER_MIN_COLUMN = "min_column";
    public static final String PARAMETER_MAX_COLUMN = "max_column";

    @Override
    public String getName() {
        return RENDERER_NAME;
    }

    public abstract DataTable getDataTable(Object var1, IOContainer var2, boolean var3);

    public boolean isSortable() {
        return true;
    }

    public boolean isColumnMovable() {
        return true;
    }

    public boolean isAutoresize() {
        return true;
    }

    @Override
    public Component getVisualizationComponent(Object renderable, IOContainer ioContainer) {
        DataTable dataTable = this.getDataTable(renderable, ioContainer, true);
        if (dataTable != null) {
            DataTableViewerTable resultTable = new DataTableViewerTable(dataTable, this.isSortable(), this.isColumnMovable(), this.isAutoresize());
            resultTable.setCellColorProvider(this.getCellColorProvider(resultTable, renderable));
            return new ExtendedJScrollPane(resultTable);
        }
        return new JLabel("No visualization possible for table.");
    }

    protected CellColorProvider getCellColorProvider(ExtendedJTable table, Object renderable) {
        return new CellColorProviderAlternating();
    }

    @Override
    public Reportable createReportable(Object renderable, IOContainer ioContainer) {
        DataTable dataTable = this.getDataTable(renderable, ioContainer, false);
        if (dataTable != null) {
            return new DefaultTableable(dataTable, this);
        }
        return null;
    }

    @Override
    public List<ParameterType> getParameterTypes(InputPort inputPort) {
        MetaData metaData;
        List<ParameterType> types = super.getParameterTypes(inputPort);
        int max_row = Integer.MAX_VALUE;
        int max_column = Integer.MAX_VALUE;
        if (inputPort != null && (metaData = inputPort.getMetaData()) != null && metaData instanceof ExampleSetMetaData) {
            ExampleSetMetaData emd = (ExampleSetMetaData)metaData;
            if (emd.getNumberOfExamples().isKnown()) {
                max_row = (Integer)emd.getNumberOfExamples().getNumber();
            }
            max_column = emd.getAllAttributes().size();
        }
        types.add(new ParameterTypeInt(PARAMETER_MIN_ROW, "Indicates the first row number which should be rendered.", 1, Integer.MAX_VALUE, 1));
        types.add(new ParameterTypeInt(PARAMETER_MAX_ROW, "Indicates the last row number which should be rendered.", 1, Integer.MAX_VALUE, max_row));
        types.add(new ParameterTypeInt(PARAMETER_MIN_COLUMN, "Indicates the first column number which should be rendered.", 1, Integer.MAX_VALUE, 1));
        types.add(new ParameterTypeInt(PARAMETER_MAX_COLUMN, "Indicates the last column number which should be rendered.", 1, Integer.MAX_VALUE, max_column));
        return types;
    }

    public static class DefaultTableable
    implements Tableable {
        private DataTable dataTable;
        private int minRow = 0;
        private int maxRow = Integer.MAX_VALUE;
        private int minColumn = 0;
        private int maxColumn = Integer.MAX_VALUE;

        public DefaultTableable(DataTable dataTable, Renderer renderer) {
            this.dataTable = dataTable;
            try {
                Object minRowO = renderer.getParameter(AbstractDataTableTableRenderer.PARAMETER_MIN_ROW);
                this.minRow = minRowO != null ? Integer.valueOf(minRowO.toString()) - 1 : 0;
            }
            catch (UndefinedParameterError e) {
                this.minRow = 0;
            }
            try {
                Object maxRowO = renderer.getParameter(AbstractDataTableTableRenderer.PARAMETER_MAX_ROW);
                this.maxRow = maxRowO != null ? Integer.valueOf(maxRowO.toString()) - 1 : Integer.MAX_VALUE;
            }
            catch (UndefinedParameterError e) {
                this.maxRow = Integer.MAX_VALUE;
            }
            try {
                Object minColO = renderer.getParameter(AbstractDataTableTableRenderer.PARAMETER_MIN_COLUMN);
                this.minColumn = minColO != null ? Integer.valueOf(minColO.toString()) - 1 : 0;
            }
            catch (UndefinedParameterError e) {
                this.minColumn = 0;
            }
            try {
                Object maxColO = renderer.getParameter(AbstractDataTableTableRenderer.PARAMETER_MAX_COLUMN);
                this.maxColumn = maxColO != null ? Integer.valueOf(maxColO.toString()) - 1 : Integer.MAX_VALUE;
            }
            catch (UndefinedParameterError e) {
                this.maxColumn = Integer.MAX_VALUE;
            }
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.dataTable.getColumnName(columnIndex + this.minColumn);
        }

        @Override
        public String getCell(int row, int column) {
            return this.dataTable.getCell(row + this.minRow, column + this.minColumn);
        }

        @Override
        public int getColumnNumber() {
            int maxC = this.maxColumn;
            if (this.maxColumn >= this.dataTable.getNumberOfColumns()) {
                maxC = this.dataTable.getNumberOfColumns() - 1;
            }
            return maxC - this.minColumn + 1;
        }

        @Override
        public int getRowNumber() {
            int maxR = this.maxRow;
            if (this.maxRow >= this.dataTable.getNumberOfRows()) {
                maxR = this.dataTable.getNumberOfRows() - 1;
            }
            return maxR - this.minRow + 1;
        }

        @Override
        public void prepareReporting() {
        }

        @Override
        public void finishReporting() {
        }

        @Override
        public boolean isFirstLineHeader() {
            return false;
        }

        @Override
        public boolean isFirstColumnHeader() {
            return false;
        }
    }
}

