/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.renderer;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.SimpleDataTable;
import com.rapidminer.gui.plotter.Plotter;
import com.rapidminer.gui.plotter.PlotterConfigurationModel;
import com.rapidminer.gui.plotter.PlotterPanel;
import com.rapidminer.gui.plotter.settings.PlotterSettingsHistory;
import com.rapidminer.gui.renderer.AbstractRenderer;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeStringCategory;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.EqualStringCondition;
import com.rapidminer.report.Reportable;
import java.awt.Component;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.List;

public abstract class AbstractDataTablePlotterRenderer
extends AbstractRenderer {
    public static final String PARAMETER_PLOTTER = "plotter";

    public abstract DataTable getDataTable(Object var1, IOContainer var2);

    @Override
    public String getName() {
        return "Plot View";
    }

    public LinkedHashMap<String, Class<? extends Plotter>> getPlotterSelection() {
        return PlotterConfigurationModel.COMPLETE_PLOTTER_SELECTION;
    }

    @Override
    public Reportable createReportable(Object renderable, IOContainer ioContainer, int width, int height) {
        DataTable dataTable = this.getDataTable(renderable, ioContainer);
        String plotterName = null;
        try {
            plotterName = this.getParameterAsString(PARAMETER_PLOTTER);
        }
        catch (UndefinedParameterError e) {
            e.printStackTrace();
        }
        PlotterConfigurationModel settings = plotterName != null ? new PlotterConfigurationModel(this.getPlotterSelection(), plotterName, dataTable) : new PlotterConfigurationModel(this.getPlotterSelection(), dataTable);
        Plotter plotter = settings.getPlotter();
        List<ParameterType> plotterParameters = plotter.getParameterTypes(null);
        if (plotterParameters != null) {
            for (ParameterType type : plotterParameters) {
                String key = type.getKey();
                try {
                    String value = this.getParameter(key);
                    if (value == null) continue;
                    settings.setParameterValue(key, value);
                }
                catch (UndefinedParameterError e) {}
            }
        }
        plotter.getPlotter().setSize(width, height);
        return plotter;
    }

    @Override
    public Component getVisualizationComponent(Object renderable, IOContainer ioContainer) {
        return new PlotterPanel(PlotterSettingsHistory.getPlotterSettingsFromHistory((IOObject)renderable, this.getDataTable(renderable, ioContainer), this.getPlotterSelection()));
    }

    @Override
    public List<ParameterType> getParameterTypes(InputPort inputPort) {
        List<ParameterType> types = super.getParameterTypes(inputPort);
        String[] availablePlotterNames = this.getPlotterSelection().keySet().toArray(new String[this.getPlotterSelection().size()]);
        ParameterTypeStringCategory plotterType = null;
        plotterType = availablePlotterNames.length == 0 ? new ParameterTypeStringCategory(PARAMETER_PLOTTER, "Indicates the type of the plotter which should be used.", availablePlotterNames, "dummy") : new ParameterTypeStringCategory(PARAMETER_PLOTTER, "Indicates the type of the plotter which should be used.", availablePlotterNames, availablePlotterNames[0]);
        plotterType.setExpert(false);
        plotterType.setEditable(false);
        types.add(plotterType);
        for (String plotterName : this.getPlotterSelection().keySet()) {
            Class<? extends Plotter> clazz = this.getPlotterSelection().get(plotterName);
            try {
                Constructor<? extends Plotter> constructor = clazz.getDeclaredConstructor(PlotterConfigurationModel.class);
                Plotter plotter = constructor.newInstance(new PlotterConfigurationModel(PlotterConfigurationModel.COMPLETE_PLOTTER_SELECTION, (DataTable)new SimpleDataTable("ForConstruction", new String[0])));
                List<ParameterType> plotterParameters = plotter.getParameterTypes(inputPort);
                if (plotterParameters == null) continue;
                for (ParameterType type : plotterParameters) {
                    type.registerDependencyCondition(new EqualStringCondition(this, PARAMETER_PLOTTER, false, plotterName));
                    type.setHidden(false);
                    type.setExpert(false);
                    types.add(type);
                }
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return types;
    }
}

