/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties.celleditors.value;

import com.rapidminer.gui.properties.TextPropertyDialog;
import com.rapidminer.gui.properties.celleditors.value.PropertyValueCellEditor;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.operator.Operator;
import com.rapidminer.parameter.ParameterTypeText;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JTable;

public class TextValueCellEditor
extends AbstractCellEditor
implements PropertyValueCellEditor {
    private static final long serialVersionUID = -4429790999365057931L;
    private ParameterTypeText type;
    private Operator operator;
    private JButton button = new JButton(new ResourceAction(true, "edit_text", new Object[0]){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            TextPropertyDialog dialog = new TextPropertyDialog(TextValueCellEditor.this.type, TextValueCellEditor.this.text, TextValueCellEditor.this.operator);
            dialog.setVisible(true);
            if (dialog.isOk()) {
                TextValueCellEditor.this.text = dialog.getText();
                TextValueCellEditor.this.setButtonText();
                TextValueCellEditor.this.fireEditingStopped();
            } else {
                TextValueCellEditor.this.fireEditingCanceled();
            }
        }
    });
    private String text = null;

    public TextValueCellEditor(ParameterTypeText type) {
        this.type = type;
        this.button.setMargin(new Insets(0, 0, 0, 0));
        this.button.setToolTipText(type.getDescription());
        this.setButtonText();
    }

    @Override
    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    @Override
    public Object getCellEditorValue() {
        return this.text;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        this.text = (String)value;
        this.setButtonText();
        return this.button;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    @Override
    public boolean useEditorAsRenderer() {
        return true;
    }

    private void setButtonText() {
        if (this.text != null && this.text.length() > 0) {
            this.button.setText("Edit Text (" + this.text.length() + " characters)...");
        } else {
            this.button.setText("Edit Text...");
        }
    }

    @Override
    public boolean rendersLabel() {
        return false;
    }
}

