/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties.celleditors.value;

import com.rapidminer.gui.properties.PropertyDialog;
import com.rapidminer.gui.properties.celleditors.value.PropertyValueCellEditor;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.dialogs.SQLQueryBuilder;
import com.rapidminer.operator.Operator;
import com.rapidminer.parameter.ParameterTypeSQLQuery;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.jdbc.DatabaseHandler;
import com.rapidminer.tools.jdbc.connection.ConnectionEntry;
import com.rapidminer.tools.jdbc.connection.ConnectionProvider;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTable;

public class SQLQueryValueCellEditor
extends AbstractCellEditor
implements PropertyValueCellEditor {
    private static final long serialVersionUID = -771727412083431607L;
    private Operator operator;
    private final JButton button;
    private String sqlQuery;

    public SQLQueryValueCellEditor(final ParameterTypeSQLQuery type) {
        this.button = new JButton(new ResourceAction(true, "build_sql", new Object[0]){
            private static final long serialVersionUID = -2911499842513746414L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DatabaseHandler handler;
                try {
                    handler = DatabaseHandler.getConnectedDatabaseHandler(SQLQueryValueCellEditor.this.operator);
                }
                catch (Exception e2) {
                    SwingTools.showSimpleErrorMessage("db_connection_failed_simple", (Throwable)e2, e2.getMessage());
                    return;
                }
                final SQLQueryBuilder queryBuilder = new SQLQueryBuilder(handler);
                boolean connectionProvided = false;
                if (SQLQueryValueCellEditor.this.operator != null && SQLQueryValueCellEditor.this.operator instanceof ConnectionProvider) {
                    ConnectionEntry entry = ((ConnectionProvider)((Object)SQLQueryValueCellEditor.this.operator)).getConnectionEntry();
                    connectionProvided = entry != null;
                    queryBuilder.setConnectionEntry(entry);
                }
                class SQLQueryPropertyDialog
                extends PropertyDialog {
                    private static final long serialVersionUID = -5224113818406394872L;

                    SQLQueryPropertyDialog(boolean editOnly) {
                        super(type, "sql");
                        this.layoutDefault((JComponent)queryBuilder.makeQueryBuilderPanel(editOnly), 1, this.makeOkButton(), this.makeCancelButton());
                    }
                }
                SQLQueryPropertyDialog dialog = new SQLQueryPropertyDialog(!connectionProvided);
                if (SQLQueryValueCellEditor.this.operator != null) {
                    String query = null;
                    try {
                        query = SQLQueryValueCellEditor.this.operator.getParameters().getParameter(type.getKey());
                    }
                    catch (UndefinedParameterError e1) {
                        // empty catch block
                    }
                    if (query != null) {
                        queryBuilder.setQuery(query);
                    }
                }
                dialog.setVisible(true);
                if (dialog.isOk()) {
                    SQLQueryValueCellEditor.this.sqlQuery = queryBuilder.getQuery();
                    SQLQueryValueCellEditor.this.fireEditingStopped();
                } else {
                    SQLQueryValueCellEditor.this.fireEditingCanceled();
                }
            }
        });
        this.button.setMargin(new Insets(0, 0, 0, 0));
    }

    @Override
    public boolean rendersLabel() {
        return false;
    }

    @Override
    public boolean useEditorAsRenderer() {
        return true;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        return this.button;
    }

    @Override
    public Object getCellEditorValue() {
        return this.sqlQuery;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.button;
    }

    @Override
    public void setOperator(Operator operator) {
        this.operator = operator;
    }
}

