/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties.celleditors.value;

import com.rapidminer.Process;
import com.rapidminer.gui.properties.celleditors.value.PropertyValueCellEditor;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.operator.Operator;
import com.rapidminer.parameter.ParameterTypeRepositoryLocation;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.repository.gui.RepositoryLocationChooser;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;

public class RepositoryLocationValueCellEditor
extends AbstractCellEditor
implements PropertyValueCellEditor {
    private static final long serialVersionUID = 1L;
    private final JPanel panel = new JPanel();
    private final JTextField textField = new JTextField(12);
    private Operator operator;

    public RepositoryLocationValueCellEditor(ParameterTypeRepositoryLocation type) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.panel.setLayout(gridBagLayout);
        this.panel.setToolTipText(type.getDescription());
        this.textField.setToolTipText(type.getDescription());
        this.textField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RepositoryLocationValueCellEditor.this.fireEditingStopped();
            }
        });
        this.textField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                RepositoryLocationValueCellEditor.this.fireEditingStopped();
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = -1;
        this.panel.add((Component)this.textField, c);
        JButton button = new JButton(new ResourceAction(true, "repository_select_location", new Object[0]){
            private static final long serialVersionUID = 1L;
            {
                this.putValue("Name", null);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String locationName;
                Process process = RepositoryLocationValueCellEditor.this.operator != null ? RepositoryLocationValueCellEditor.this.operator.getProcess() : null;
                RepositoryLocation processLocation = null;
                if (process != null && (processLocation = process.getRepositoryLocation()) != null) {
                    processLocation = processLocation.parent();
                }
                if ((locationName = RepositoryLocationChooser.selectLocation(processLocation, RepositoryLocationValueCellEditor.this.textField.getText(), RepositoryLocationValueCellEditor.this.panel, true, false)) != null) {
                    RepositoryLocationValueCellEditor.this.textField.setText(locationName);
                }
                RepositoryLocationValueCellEditor.this.fireEditingStopped();
            }
        });
        button.setMargin(new Insets(0, 0, 0, 0));
        c.gridwidth = 0;
        c.weightx = 0.0;
        this.panel.add((Component)button, c);
    }

    @Override
    public Object getCellEditorValue() {
        return this.textField.getText().trim().length() == 0 ? null : this.textField.getText().trim();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        this.textField.setText(value == null ? "" : value.toString());
        return this.panel;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    @Override
    public boolean useEditorAsRenderer() {
        return true;
    }

    @Override
    public boolean rendersLabel() {
        return false;
    }

    @Override
    public void setOperator(Operator operator) {
        this.operator = operator;
    }
}

